#include <dataserv.h>

#define FAIL(error)               \
        {                         \
          kinfo(KFORCE,error);    \
          kexit(KEXIT_FAILURE);   \
        }

/*  //  This test program checks the optimal region size functionality of the
 *  //  kpds optimal region size attribute code by setting a bunch of 
 *  //  attributes, closing and reopening the object, and then reading 
 *  //  the attributes and printing them.
 */



main()
{
   kobject i;
   unsigned char *data;
   float *fdata;
   int j, begin[5], end[5], size[5];
   int order[5] = {KMAP_WIDTH, KMAP_HEIGHT, KMAP_DEPTH, KMAP_TIME, 
		KMAP_ELEMENTS};   

   i = kdms_input("$DATASERV/data/testdata/100x100.ubyte.xvimage");
   kdms_create_segment(i,KDMS_SEGMENT_MAP);

   size[0] = 3; size[1] = 256; size[2] = size[3] = size[4] = 1;
 
   kdms_set_attributes(i,KDMS_SEGMENT_MAP, 
		       KDMS_DIMENSION, 5,
		       KDMS_SIZE, size, 
		       KDMS_INDEX_ORDER, order, 
		       KDMS_DATA_TYPE, KUBYTE, NULL);

   /* 
    * get an empty chunk of data 
    */
   begin[0] = begin[1] = begin[2] = begin[3] = begin[4] = 0;
   end[0] = 2; end[1] = end[2] = end[3] = end[4] = 0;
   data = kdms_get_data(i,KDMS_SEGMENT_MAP,begin,end,NULL);

   /*
    * initialize the segment with a recognizable sequence
    */
   for(j=0;j<256;j++) {
       data[0] = (unsigned char)j;
       data[1] = (unsigned char)j+1;
       data[2] = (unsigned char)j+2;

       kdms_put_data(i,KDMS_SEGMENT_MAP,begin,end,data);
       begin[1] ++;
       end[1] ++;
   }
   kfree(data);  data = NULL;

   /*
    * print out what I just wrotein.
    */
   for(j=0;j<256;j++) {
      begin[1] = end[1] = j;
      data = kdms_get_data(i,KDMS_SEGMENT_MAP,begin,end,data);
      kprintf("%.2x %.2x %.2x\n",(long)data[0],(long)data[1],(long)data[2]);
   }
   kfree(data);

   /*
    * change the size and data type of the data 
    */
   size[0] = 5;
   kdms_set_attributes(i,KDMS_SEGMENT_MAP, KDMS_SIZE, size,
	KDMS_DATA_TYPE, KFLOAT, NULL);

   begin[1] = end[1] = 0;
   end[0] = 4;
   fdata = kdms_get_data(i,KDMS_SEGMENT_MAP,begin,end,NULL);
   for(j=0;j<256;j++) {
       begin[1] = end[1] = j;
       fdata[0] = (float)j;
       fdata[1] = (float)j*j;
       fdata[2] = (float)j*j*j;
       fdata[3] = (float)j*j;
       fdata[4] = (float)j;

       kdms_put_data(i,KDMS_SEGMENT_MAP,begin,end,fdata);
   }
   kfree(fdata);  fdata = NULL;

   for(j=0;j<256;j++) {
      begin[1] = end[1] = j;
      fdata = kdms_get_data(i,KDMS_SEGMENT_MAP,begin,end,fdata);
      kprintf("%f %f %f %f %f\n",fdata[0],fdata[1],fdata[2],fdata[3],
		fdata[4]);

   }
   kfree(fdata);

   kdms_close(i);      
   kexit(0);
}
