#include "dataserv.h"
#define TESTNAME "test.xv"

main()
{
   kobject o;
   int i, status;
   int size[2] = {1,1};

   o = kdms_output(TESTNAME);

/*
 * Phase 1 is the attribute definition testing
 */

	kprintf("Phase 1...\n");

#define ATTRIB_ALL "attributeOverAllSegments"
   /* generic attribute over all segments */
   kdms_define_attribute(KDMS_ALL_SEGMENTS,ATTRIB_ALL,1,1,KINT,FALSE,FALSE,2);

#define ATTRIB_DILBERT "attributeOverDilbert"
   /* generic attribute over 'dilbert' segment */
   kdms_define_attribute("dilbert",ATTRIB_DILBERT,1,1,KINT,FALSE,FALSE,8);

#define ATTRIB_DOGBERT "attributeOverAllDogbert"
   /* generic attribute over 'dogbert' segment */
   kdms_define_attribute("dogbert",ATTRIB_DOGBERT,1,1,KINT,FALSE,FALSE,4);

   /* create a number of segments to test with */
   kdms_create_segment(o,"hobbes");
   kdms_set_attributes(o,"hobbes",
		KDMS_DIMENSION,2,KDMS_SIZE,size,KDMS_DATA_TYPE,KBYTE,NULL);
   kdms_create_segment(o,"dilbert");
   kdms_set_attributes(o,"dilbert",
		KDMS_DIMENSION,2,KDMS_SIZE,size,KDMS_DATA_TYPE,KBYTE,NULL);
   kdms_create_segment(o,"dogbert");
   kdms_set_attributes(o,"dogbert",
		KDMS_DIMENSION,2,KDMS_SIZE,size,KDMS_DATA_TYPE,KBYTE,NULL);

   	/* 
	 * test set the ATTRIB_ALL attribute on every segment 
	 */

   status = TRUE;

   if (kdms_get_attribute(o, NULL, ATTRIB_ALL, &i) && (i == 2)) {
      kprintf("\tERROR : attribute over all segments works on object!\n");  
      status = FALSE;
   }

   if (!kdms_get_attribute(o, "hobbes", ATTRIB_ALL, &i) || (i != 2)){
      kprintf("\tERROR : attribute over all segments failed on 'hobbes'\n");
      status = FALSE;
   }

   if (!kdms_get_attribute(o, "dilbert", ATTRIB_ALL, &i) || (i != 2)){
      kprintf("\tERROR : attribute over all segments failed on 'dilbert'\n");
      status = FALSE;
   }

   if (!kdms_get_attribute(o,"dogbert", ATTRIB_ALL, &i) || (i != 2)){
      kprintf("\tERROR : attribute over all segments failed on "
	      "'dogbert'\n");
      status = FALSE;
   }

   if (status)
      kprintf("\tattribute defined over all segments succeeded!\n");
   else
      kprintf("\tattribute defined over all segments unsuccessful...\n");


   	/* 
	 * test set the ATTRIB_DILBERT attribute on every segment 
	 */

   status = TRUE;

   if (kdms_get_attribute(o, NULL, ATTRIB_DILBERT, &i) && (i == 8)) {
      kprintf("\tERROR : attribute over dilbert works on object!\n");  
      status = FALSE;
   }

   if (kdms_get_attribute(o, "hobbes", ATTRIB_DILBERT, &i) && (i == 8)){
      kprintf("\tERROR : attribute over dilbert worked on 'hobbes'\n");
      status = FALSE;
   }

   if (!kdms_get_attribute(o, "dilbert", ATTRIB_DILBERT, &i) || (i != 8)){
      kprintf("\tERROR : attribute over dilbert failed on 'dilbert'\n");
      status = FALSE;
   }

   if (kdms_get_attribute(o,"dogbert",ATTRIB_DILBERT,&i) && (i == 8)){
      kprintf("\tERROR : attribute over dilbert worked on "
	      "'dogbert'\n");
      status = FALSE;
   }

   if (status)
      kprintf("\tattribute defined only on dilbert succeeded!\n");
   else
      kprintf("\tattribute defined only on dilbert unsuccessful...\n");

   	/* 
	 * test set the ATTRIB_DOGBERT attribute on every segment 
	 */

   status = TRUE;

   if (kdms_get_attribute(o, NULL, ATTRIB_DOGBERT, &i) && (i == 4)) {
      kprintf("\tERROR : attribute over dogbert works on object!\n");  
      status = FALSE;
   }

   if (kdms_get_attribute(o, "hobbes", ATTRIB_DOGBERT, &i) && (i == 4)){
      kprintf("\tERROR : attribute over dogbert worked on 'hobbes'\n");
      status = FALSE;
   }

   if (kdms_get_attribute(o, "dilbert", ATTRIB_DOGBERT, &i) && (i == 4)){
      kprintf("\tERROR : attribute over dogbert works on 'dilbert'\n");
      status = FALSE;
   }

   if (!kdms_get_attribute(o,"dogbert",ATTRIB_DOGBERT,&i) || (i != 4)){
      kprintf("\tERROR : attribute over dogbert failed on "
	      "'dogbert'\n");
      status = FALSE;
   }

   if (status)
      kprintf("\tattribute defined on dogbert succeeded!\n");

   kdms_close(o);
   kexit(0);
}
