 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            
   >>>>
   >>>>  Private:
   >>>>             
   >>>>   Static:
   >>>>             
   >>>>   Public:
   >>>>             
   >>>>             
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

int
   KDMS_EINTERNAL,
   KDMS_ELIMITATION,
   KDMS_ENULLOP,
   KDMS_EWRACCESS,
   KDMS_EREADWRITE_LIMITATION,
   KDMS_EOBJ_INVALID,
   KDMS_EOBJ_SUPPORT,
   KDMS_ESEG_EXISTS,
   KDMS_ESEG_NONEXIST,
   KDMS_ESEG_VALID,
   KDMS_ESEG_LOCKED,
   KDMS_ESEG_READFAIL,
   KDMS_EFMT_FAILURE,
   KDMS_EFMT_READFAIL,
   KDMS_EFMT_WRITEFAIL,
   KDMS_EFMT_OPENFAIL,
   KDMS_EFMT_INIT,
   KDMS_EATTR_SIZEDIM,
   KDMS_EATTR_ORDERDIM,
   KDMS_EATTR_NULLARGS,
   KDMS_EATTR_NODEF,
   KDMS_EATTR_INVALID,
   KDMS_EATTR_ILLEGAL_ASSOC,
   KDMS_EATTR_UNSET,
   KDMS_EATTR_NOT_FOUND,
   KDMS_EATTR_ALREADY_EXISTS,
   KDMS_EATTR_DEF_EXISTS,
   KDMS_EATTR_SET_FAILED,
   KDMS_EATTR_GET_FAILED,
   KDMS_EATTR_COPY_FAILED,
   KDMS_ECOMP_ALLOC_FAIL,
   KDMS_ECOMP_POS_INVALID,
   KDMS_EDIM_INVALID,
   KDMS_EDIM_NO_MATCH,
   KDMS_EINDX_INVALID,
   KDMS_ESYNC_NOT,
   KDMS_ESYNC_INVALID,
   KDMS_ECB_NONEXIST;

static kerrlist errors[] =
{
   {&KDMS_EINTERNAL,
    "An internal error occured in data services."},
   {&KDMS_ELIMITATION,
    "There is a limitation in data services that prevents this operation from working correctly.  Sorry for the inconvenience."},
   {&KDMS_ENULLOP,
 "With the operands specified, this operation doesn't really do anything."},
   {&KDMS_EWRACCESS,
  "The file name specified cannot be written to.  Open operation aborted."},
   {&KDMS_EFMT_FAILURE,
    "Failed to read, write, or create file format header."},
   {&KDMS_EFMT_READFAIL,
    "Failed to read file format data from transport."},
   {&KDMS_EFMT_WRITEFAIL,
    "Failed to read file format data from transport."},
   {&KDMS_EFMT_OPENFAIL,
    "Unable to open the specified file."},
   {&KDMS_EREADWRITE_LIMITATION,
    "The KOBJ_READ and KOBJ_WRITE flags are not yet supported simultaneously on the same object."},
   {&KDMS_EOBJ_INVALID,
    "NULL object passed into a data services routine"},
   {&KDMS_ESEG_NONEXIST,
    "The specified segment does not exist."},
   {&KDMS_ESEG_EXISTS,
    "The specified segment already exists."},
   {&KDMS_EATTR_SIZEDIM,
    "Accessing size attribute on segment with unknown dimensionality."},
   {&KDMS_EATTR_ORDERDIM,
 "Accessing index order attribute on segment with unknown dimensionality."},
   {&KDMS_EATTR_NULLARGS,
    "Null arguments passed into attribute operation."},
   {&KDMS_EATTR_NODEF,
    "The attribute does not exist and is not defined at specified scope."},
   {&KDMS_EATTR_INVALID,
    "Attribute has invalid data type."},
   {&KDMS_EATTR_ILLEGAL_ASSOC,
    "Illegal attribute association encountered."},
   {&KDMS_EATTR_UNSET,
    "Attribute has never been set."},
   {&KDMS_EATTR_NOT_FOUND,
    "Unable to locate attribute."},
   {&KDMS_EATTR_ALREADY_EXISTS,
    "Attribute already exists."},
   {&KDMS_EATTR_DEF_EXISTS,
    "A definition for the attribute already exists."},
   {&KDMS_EATTR_SET_FAILED,
    "Failed to set attribute."},
   {&KDMS_EATTR_GET_FAILED,
    "Failed to get attribute."},
   {&KDMS_EATTR_COPY_FAILED,
    "Failed to copy attribute."},
   {&KDMS_EOBJ_SUPPORT,
    "Unable to find any support for the specified format.  It is possible that the Data Services library was compiled with no file format support."},
   {&KDMS_EFMT_INIT,
    "The file format has already been initialized."},
   {&KDMS_ESYNC_NOT,
  "The specified segment is uncoupled.  No synchronization was performed."},
   {&KDMS_ESYNC_INVALID,
    "The specified synchronization direction is invalid.  No synchronization was performed."},
   {&KDMS_ECB_NONEXIST,
    "Specified callback does not exist, so it cannot be removed."},
   {&KDMS_ESEG_VALID,
    "You must specify a valid segment."},
   {&KDMS_ESEG_LOCKED,
    "The specified segment has already been locked."},
   {&KDMS_ESEG_READFAIL,
    "Failed to read segment data from the data object."},
   {&KDMS_ECOMP_ALLOC_FAIL,
    "Failed to allocate an aggregate component."},
   {&KDMS_ECOMP_POS_INVALID,
    "The component position for the specified aggregate is invalid."},
   {&KDMS_EDIM_INVALID,
    "The specified dimension is not valid."},
   {&KDMS_EDIM_NO_MATCH,
    "The dimension for the specified segement does not match what was expected."},
   {&KDMS_EINDX_INVALID,
    "The specified index order is not valid."},
};

static int num_errors = knumber(errors);

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_init_errors
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: 
|          Date: Nov 03, 1993 16:16
| Modifications:
|
------------------------------------------------------------*/

void 
_kdms_init_errors(void)
{
   kerrno_init_errors(errors, num_errors);
}
