 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Geometry Application Services
   >>>>                  Utility Routines
   >>>>
   >>>>   Static:
   >>>>			_kgeom_init_errors()
   >>>>  Private:
   >>>>			kgeom_init()  
   >>>>			kgeom_color_size()  
   >>>>			kgeom_manifest_name()  
   >>>>			kgeom_component_name()  
   >>>>			kgeom_all_primitive_name() 
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "geom_internals.h"

int _geom_initialized = FALSE;

/* ################################################################## */

int
   KGEOM_EINTERNAL,
   KGEOM_ELIMITATION,
   KGEOM_EINTERNAL_GET_ATTRIBUTES,
   KGEOM_EINTERNAL_SET_ATTRIBUTES,
   KGEOM_ENO_PRIMITIVE_LIST,
   KGEOM_EFAILED_PRIMITIVE_LIST_SET,
   KGEOM_ENULL_PRIMITIVE_LIST_PROVIDED,
   KGEOM_EINVALID_NUMBER_PRIMITIVES,
   KGEOM_EINVALID_PRIMITIVE_POSITION,
   KGEOM_EUNABLE_TO_ESTABLISH_PRIMITIVE,
   KGEOM_EPRIMITIVE_REDEFINED,
   KGEOM_EPRIMITIVE_NO_DEFINITION,
   KGEOM_EPRIMITIVE_NO_MATCH_POSITION,
   KGEOM_EINVALID_PRESENTATION,
   KGEOM_EUNABLE_TO_PROVIDE_PRESENTATION,
   KGEOM_EMUST_PROVIDE_PRESENTATION_HANDLER,
   KGEOM_EMISSING_REQUIRED_COMPONENT,
   KGEOM_EINVALID_PRIMITIVE,
   KGEOM_EOBJ_INVALID,
   KGEOM_ERECREATE_QUADMESH,
   KGEOM_ERECREATE_OCTMESH,
   KGEOM_ERECREATE_TEXTURE2D,
   KGEOM_ERECREATE_TEXTURE3D,
   KGEOM_ERECREATE_MAP,
   KGEOM_EHAS_QUADMESH,
   KGEOM_EHAS_OCTMESH,
   KGEOM_EHAS_TEXTURE2D,
   KGEOM_EHAS_TEXTURE3D,
   KGEOM_ENO_QUADMESH,
   KGEOM_ENO_OCTMESH,
   KGEOM_ENO_TEXTURE2D,
   KGEOM_ENO_TEXTURE3D,
   KGEOM_ENO_MAP;

static kerrlist gerrors[] = {
  { &KGEOM_EINTERNAL,
    "An internal error occured in geometry services."},
  { &KGEOM_EINTERNAL_GET_ATTRIBUTES,
    "Internal Error - Failed to get internal attributes."},
  { &KGEOM_EINTERNAL_SET_ATTRIBUTES,
    "Internal Error - Failed to set internal attributes."},
  { &KGEOM_ELIMITATION,
    "There is currently a limitation in geometry services that prevents "
    "this operation from working correctly.  Sorry for the inconvenience."},
  { &KGEOM_ENO_PRIMITIVE_LIST,
    "No primitive list present!\n"
    "Primitive list must be created with kgeom_create_primitive_list()."},
  { &KGEOM_EFAILED_PRIMITIVE_LIST_SET,
    "Failed to set the primitive list."},
  { &KGEOM_ENULL_PRIMITIVE_LIST_PROVIDED,
    "NULL primitive list provided"},
  { &KGEOM_EINVALID_NUMBER_PRIMITIVES,
    "Invalid Number of Primitives provided"},
  { &KGEOM_EINVALID_PRIMITIVE_POSITION,
    "Invalid Primitive Position provided"},
  { &KGEOM_EUNABLE_TO_ESTABLISH_PRIMITIVE,
    "Internal Error - Unable to establish primitive."},
  { &KGEOM_EPRIMITIVE_REDEFINED,
    "Unable to redefine primitive."},
  { &KGEOM_EPRIMITIVE_NO_DEFINITION,
    "No definition found for specified primitive."},
  { &KGEOM_EPRIMITIVE_NO_MATCH_POSITION,
    "The specified primitive does not match the primitive at the current "
    "primitive position the primitive list."},
  { &KGEOM_EINVALID_PRESENTATION,
    "The presentation for this data component is invalid."},
  { &KGEOM_EUNABLE_TO_PROVIDE_PRESENTATION,
    "An error has occured in the data presentation"},
  { &KGEOM_EMUST_PROVIDE_PRESENTATION_HANDLER,
    "The given presentation handler is NULL -\n"
    "a presentation handler must be provided."},
  { &KGEOM_EMISSING_REQUIRED_COMPONENT,
    "A required data component is missing from the kgeom_putdata call"},
  { &KGEOM_EINVALID_PRIMITIVE,
    "The specified primitive is invalid."},
  { &KGEOM_EOBJ_INVALID,
    "NULL object passed in."},
  { &KGEOM_ERECREATE_QUADMESH,
    "Quadmesh already exists."},
  { &KGEOM_ERECREATE_OCTMESH,
    "Octmesh already exists."},
  { &KGEOM_ERECREATE_TEXTURE2D,
    "2D Texture already exists."},
  { &KGEOM_ERECREATE_TEXTURE3D,
    "3D Texture already exists."},
  { &KGEOM_ERECREATE_MAP,
    "Map already exists."},
  { &KGEOM_EHAS_QUADMESH,
    "Object was already explicitly created to contain a quadmesh."},
  { &KGEOM_EHAS_OCTMESH,
    "Object was already explicitly created to contain a octmesh."},
  { &KGEOM_EHAS_TEXTURE2D,
    "Object was already explicitly created to contain a 2D texture."},
  { &KGEOM_EHAS_TEXTURE3D,
    "Object was already explicitly created to contain a 3D texture."},
  { &KGEOM_ENO_QUADMESH,
    "Must create a quadmesh first"},
  { &KGEOM_ENO_OCTMESH,
    "Must create a octmesh first"},
  { &KGEOM_ENO_TEXTURE2D,
    "Must create a texture2d first"},
  { &KGEOM_ENO_TEXTURE3D,
    "Must create a texture3d first"},
  { &KGEOM_ENO_MAP,
    "Must create a map first"},

};  

static int number_errors = knumber(gerrors);

/*-----------------------------------------------------------
|
|  Routine Name: (static) _kgeom_init_errors
|
|       Purpose: Initialize the error messages for errno handling  
|
|         Input: None
|
|        Output: None
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steven Kubica 
|          Date: Dec 4, 1993 
| Modifications:
|
------------------------------------------------------------*/
static void 
_kgeom_init_errors(void)
{
   kerrno_init_errors(gerrors, number_errors);
}

/* ################################################################## */

/* 
 *    ================================================================== 
 *    Initialization Routines
 *    ==================================================================
 */

/*-----------------------------------------------------------
|
|  Routine Name: kgeom_init
|
|       Purpose: Initialize all of the primitives and
|                attributes needed by geometry services 
|
|         Input: none
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Mar 06, 1994 15:26
| Modifications:
|
------------------------------------------------------------*/
int 
kgeom_init(void)
{
   if ( _geom_initialized == TRUE )
      return TRUE;

   /* Prevent this routine from being called again */
   _geom_initialized = TRUE;

   /* Initialize all geometry services error messages */
   _kgeom_init_errors();

   /* Initialize all geometry services attributes */ 
   kgeom_define_attributes();

   /* Initialize all geometry services primitives */
   kgeom_define_primitives();

   /* Initialize all geometry services meshes */
   kgeom_define_meshes();

   /* Initialize all geometry services segments */
   kgeom_define_segments();

   /* Initialize all polymorphic services segments */
   kpds_init();

   /*
    *  It is possible to generate errnos with duplicate attribute
    *  definitions.  To prevent the user from seeing this, we'll
    *  re-zero the errno.
    */
   errno = 0;

   return TRUE;
}

/* ################################################################## */

/*-----------------------------------------------------------
|
|  Routine Name: kgeom_layout
|
|       Purpose: This routine returns the current setting
|		 of the KGEOM_LAYOUT attribute
|
|         Input: obj - the object to retrieve the attribute from
|
|        Output: none
|
|       Returns: the current setting of KGEOM_LAYOUT
|
|    Written By: Steve Kubica
|          Date: Aug 20, 1994 11:56
| Modifications:
|
------------------------------------------------------------*/
int
kgeom_layout(kobject obj)
{
   int layout;
   
   if (!kgeom_get_attribute(obj, KGEOM_OBJECT, KGEOM_LAYOUT, &layout))
      return -1;
   else
      return layout;
}

/*-----------------------------------------------------------
|
|  Routine Name: kgeom_color_size
|
|       Purpose: This routine checks the current colorspace and
|		 the has alpha attributes to determine the current 
|		 size of a color vector for the given segment.
|	
|		 In general, the color size is determined by the
|		 colorspace model and the presence or absence of
|		 the alpha channel.  
|
|		 If the segment being checked is not the map, then
|		 the colorsize will be 1 if there is a map present,
|		 (meaning that the color data will be mapped) --
|		 otherwise, the colorsize will be determined by
|		 the colorspace.   If there is a map segment, it
|		 is assumed that the colorsize will represent
|		 the width of the map.
|
|         Input: object  - the object to determine the colorsize for
|		 segment - the segment being checked
|
|        Output: None
|
|       Returns: the color vector size on success, -1 on failure
|
|    Written By: Steven Kubica 
|          Date: May 11, 1994 15:35
| Modifications:
|
------------------------------------------------------------*/
int 
kgeom_color_size(
   kobject  obj,
   char    *segment)
{
   int cspace;
   int has_alpha;
   int csize;
   int has_map;


   has_map = kdms_query_segment(obj,KDMS_SEGMENT_MAP);

   /* 
    *   if this is not the map segment and we have a map, then our 
    *   color is a map index and our colorsize is going to be one.
    */
   if (segment != NULL)
   {
      if (has_map && (kstrcmp(segment,KDMS_SEGMENT_MAP) != 0))
         return 1;

      /* if this the the map segment, and we have no map, then 	
	 return -1 to indicate that there is no map width */
      if (!has_map && (kstrcmp(segment,KDMS_SEGMENT_MAP) == 0))
	 return -1;
      
   }
   

   /* othewise, the color is determined by the colorspace and has alpha */
   if (!kgeom_get_attributes(obj,KGEOM_OBJECT,
	  		         KGEOM_COLORSPACE,&cspace,
			         KGEOM_HAS_ALPHA, &has_alpha,
			         NULL))
      return -1;

   switch(cspace)
   {
        case KNONE:  
	case KGREY:		csize = 1;  break;
	case KRGB: 		
	case KCMY: 		
	case KYIQ: 		
	case KHSV: 		
	case KHLS: 		
	case KIHS: 		
	case KXYZ: 		
	case KUVW: 		
	case KUCSUVW:		
	case KUCSSOW:		
	case KUCSLab:		
	case KUCSLuv:		csize = 3;  break;
	case KUSERDEFINED: 	csize = 3;  break;

	default:
	   /* errno = INVALID COLORSPACE! */
     	   return -1;
   }

   /* The alpha channel adds one to the color size */
   if (has_alpha) csize++;

   return csize;
}


/* ################################################################## */

/*
 *    ==================================================================
 *    Naming Routines
 *    ==================================================================
 */

/*-----------------------------------------------------------
|  Routine Name: kgeom_attribute_name
|       Purpose: generate unique string for given position
|
|  		"position" + "attribute"
|
|    Written By: Steve Kubica
|          Date: Apr 14, 1993 16:05
-----------------------------------------------------------*/
char *kgeom_attribute_name(
   char *attribute,
   int   position)
{
   char temp[KLENGTH];

   ksprintf(temp, "%d.%s\0", position, attribute);
   return kstrdup(temp);
}
