 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
/* See $DATASERV/repos/copyright/Copyright for terms and conditions. */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Colorspace conversion definitions
   >>>>
   >>>>    Written By: Mark Young and Patrick Arnoul
   >>>>
   >>>>          Date: Aug 06, 1992 10:28
   >>>>
   >>>> Modifications: Converted from Khoros 1.0 (MY)
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>      contains: specification of the linear trans-
   >>>>                formation matricies for conversion
   >>>>		       between ntscYIQ, cieXYZ, cieUVW and
   >>>>                ntscRGB or genericRGB colorspaces.
   >>>>		       This transformations were taken from
   >>>>		       Pratt (Digital Image Processing, 1978).
   >>>>		       The values in the matricies are NTSC
   >>>>                standard tristimulus values, as
   >>>>                described by Pratt.
   >>>>
   >>>>      written by: Tom Sauer, Donna Koechner, Mark Young
   >>>>
   >>>>      date: 1/24/89
   >>>>
   >>>>      modifications: converted to khoros by Tom Sauer
   >>>>			    6/6/89
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _colorspace_h_
#define _colorspace_h_

/*
 *
 *	The following algorithms are variations from:
 *		"Computer Graphics"
 *		Donald Hearn / m. Pauline Baker
 *		PRENTICE-HALL
 *		pg 303-306
 *
 *		"Fundamentals of Interactive Computer Graphics"
 *		J.D Foley / A. Van Dam
 *		Addison-Wesley
 *		pg 613-616
 *
 *	The only difference is that the color spaces were
 *	normalized for the X window system.  Both RGB & CMY
 *	are ranged from 0 to 255 (MAX_INTEN).  The HSV &
 *	HLS space is normalized between 0.0 and 1.0
 *
 */


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#ifndef MAX_INTEN
#define MAX_INTEN 255
#endif

#define trans1(t1,t2,t3,mat) (mat[0][0]*(t1) + mat[0][1]*(t2) + mat[0][2]*(t3))
#define trans2(t1,t2,t3,mat) (mat[1][0]*(t1) + mat[1][1]*(t2) + mat[1][2]*(t3))
#define trans3(t1,t2,t3,mat) (mat[2][0]*(t1) + mat[2][1]*(t2) + mat[2][2]*(t3))


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

typedef double trans_mat[3][3];

#if 0

/*
 * The transformation matrices below are not in use, so they have been
 * commented out for now.  JW Nov 02, 1994 16:110
 */

static trans_mat RGBtoYIQ = { { 0.299,  0.587,  0.114},
			      { 0.596, -0.274, -0.322},
			      { 0.211, -0.523,  0.312} };

static trans_mat RGBtoXYZ = { { 0.607,  0.174,  0.201},
			      { 0.299,  0.587,  0.114},
			      { 0.000,  0.066,  1.117} };
 
static trans_mat RGBtoUVW = { { 0.405,  0.116,  0.133},
			      { 0.299,  0.587,  0.114},
			      { 0.145,  0.827,  0.627} };

static trans_mat YIQtoRGB = { { 1.000,  0.956,  0.621},
			      { 1.000, -0.272, -0.647},
			      { 1.000, -1.106,  1.703} };

static trans_mat YIQtoXYZ = { { 0.967,  0.318,  0.594},
			      { 1.000,  0.000,  0.000},
			      { 1.173, -1.238,  1.870} };

static trans_mat YIQtoUVW = { { 0.653,  0.208,  0.403},
			      { 1.000,  0.000,  0.000},
			      { 1.599, -0.780,  0.623} };

static trans_mat XYZtoRGB = { { 1.910, -0.533, -0.288},
			      {-0.985,  2.000, -0.028},
			      { 0.058, -0.118,  0.896} };

static trans_mat XYZtoYIQ = { { 0.000,  1.000,  0.000},
			      { 1.407, -0.842, -0.451},
			      { 0.932,  1.189,  0.233} };

static trans_mat XYZtoUVW = { { 0.667,  0.000,  0.000},
			      { 0.000,  1.000,  0.000},
			      {-0.500,  1.500,  0.500} };

static trans_mat UVWtoRGB = { { 2.432,  0.332, -0.576},
			      {-1.519,  2.083, -0.057},
			      { 1.440, -2.823,  1.803} };

static trans_mat UVWtoYIQ = { { 0.000,  1.000,  0.000},
			      { 1.403,  0.534, -0.907},
			      { 1.757, -1.898,  0.470} };

static trans_mat UVWtoXYZ = { { 1.500,  0.000,  0.000},
			      { 0.000,  1.000,  0.000},
			      { 1.500, -3.000,  2.000} };

#endif

	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/*
 *  Helper routines for the RGB_to_HSV() & HSV_to_RGB()
 *  functions.
 *
 *  normalize() converts a number from 0 - MAX_INTEN to
 *  0 - 1.
 *
 *  normalize_rgb() converts a number from 0 - 1 to
 *  0 - MAX_INTEN.
 */
#define normalize(v)	 (((double) (v)) / MAX_INTEN)
#define normalize_rgb(v) ((unsigned short) ((v) * MAX_INTEN + 0.5))


#define  RGB_to_CMY(r, g, b, cyan, magenta, yellow)			\
{									\
	cyan    = MAX_INTEN - r;					\
	magenta = MAX_INTEN - g;					\
	yellow  = MAX_INTEN - b;					\
}

#define  CMY_to_RGB(cyan, magenta, yellow, r, g, b)			\
{									\
	r = MAX_INTEN - cyan;						\
	g = MAX_INTEN - magenta;					\
	b = MAX_INTEN - yellow;						\
}

#define  RGB_to_YIQ(r, g, b, y, i, q)					\
{									\
	static double	tmp_r, tmp_g, tmp_b;				\
									\
	tmp_r = normalize(r);						\
	tmp_g = normalize(g);						\
	tmp_b = normalize(b);						\
	y = trans1(tmp_r, tmp_g, tmp_b, RGBtoYIQ);			\
	i = trans2(tmp_r, tmp_g, tmp_b, RGBtoYIQ);			\
	q = trans3(tmp_r, tmp_g, tmp_b, RGBtoYIQ);			\
}

#define  YIQ_to_RGB(y, i, q, r, g, b)					\
{									\
	r = normalize_rgb(trans1(y, i, q, YIQtoRGB));			\
	g = normalize_rgb(trans2(y, i, q, YIQtoRGB));			\
	b = normalize_rgb(trans3(y, i, q, YIQtoRGB));			\
}

#define  RGB_to_XYZ(r, g, b, x, y, z)					\
{									\
	static double	tmp_r, tmp_g, tmp_b;				\
									\
	tmp_r = normalize(r);						\
	tmp_g = normalize(g);						\
	tmp_b = normalize(b);						\
	x = trans1(tmp_r, tmp_g, tmp_b, RGBtoXYZ);			\
	y = trans2(tmp_r, tmp_g, tmp_b, RGBtoXYZ);			\
	z = trans3(tmp_r, tmp_g, tmp_b, RGBtoXYZ);			\
}

#define  XYZ_to_RGB(x, y, z, r, g, b)					\
{									\
	r = normalize_rgb(trans1(x, y, z, XYZtoRGB));			\
	g = normalize_rgb(trans2(x, y, z, XYZtoRGB));			\
	b = normalize_rgb(trans3(x, y, z, XYZtoRGB));			\
}

#define  RGB_to_UVW(r, g, b, u, v, w)					\
{									\
	static double	tmp_r, tmp_g, tmp_b;				\
									\
	tmp_r = normalize(r);						\
	tmp_g = normalize(g);						\
	tmp_b = normalize(b);						\
	u = trans1(tmp_r, tmp_g, tmp_b, RGBtoUVW);			\
	v = trans2(tmp_r, tmp_g, tmp_b, RGBtoUVW);			\
	w = trans3(tmp_r, tmp_g, tmp_b, RGBtoUVW);			\
}

#define  UVW_to_RGB(u, v, w, r, g, b)					\
{									\
	r = normalize_rgb(trans1(u, v, w, UVWtoRGB));			\
	g = normalize_rgb(trans2(u, v, w, UVWtoRGB));			\
	b = normalize_rgb(trans3(u, v, w, UVWtoRGB));			\
}



/*
 *  Convert  RGB_to_HSV()  - converts a Red, Green, Blue number
 *			     to a Hue, Saturation, Value one.
 */
#define  RGB_to_HSV(r, g, b, h, s, v)					\
{									\
	static double	tmp_m, tmp_r, tmp_g, tmp_b;			\
									\
	tmp_r = normalize(r);						\
	tmp_g = normalize(g);						\
	tmp_b = normalize(b);						\
	v = kmax3(tmp_r, tmp_g, tmp_b);					\
	tmp_m = kmin3(tmp_r, tmp_g, tmp_b);				\
									\
	if (v == 0.0)							\
	   s = 0.0;							\
	else s = (v - tmp_m)/v;						\
									\
	if (s == 0.0)							\
	   h = 0.0;							\
	else								\
	{								\
	   if (tmp_r == v)						\
	      h = ((v - tmp_b)/(v - tmp_m)) - ((v - tmp_g)/(v - tmp_m)); \
	   else if (tmp_g == v)						\
	      h = 2 + ((v - tmp_r)/(v - tmp_m)) - ((v - tmp_b)/(v - tmp_m)); \
	   else if (tmp_b == v)						\
	      h = 4 + ((v - tmp_g)/(v - tmp_m)) - ((v - tmp_r)/(v - tmp_m)); \
									\
	   h /= 6.0;							\
	   if (h < 0.0) h += 1.0;					\
	}								\
}


/*
 *  Convert  HSV_to_RGB()  - converts a Hue, Saturation, Value number
 *			     to a Red, Green, Blue one.
 */
#define HSV0(v, s, f)	normalize_rgb(v)
#define HSV1(v, s, f)	normalize_rgb(v * (1 - s))
#define HSV2(v, s, f)	normalize_rgb(v * (1 - (s * f)))
#define HSV3(v, s, f)	normalize_rgb(v * (1 - (s * (1 - f))))

#define  HSV_to_RGB(h, s, v, r, g, b)					\
{									\
	static int	tmp_i;						\
	static double	tmp_f;						\
									\
	tmp_i = (int) (h * 6.0);					\
	tmp_f = (h * 6.0) - tmp_i;					\
									\
	switch(tmp_i)							\
	{								\
	     case 0:    r = HSV0(v, s, tmp_f);				\
			g = HSV3(v, s, tmp_f);				\
			b = HSV1(v, s, tmp_f);				\
			break;						\
									\
	     case 1:    r = HSV2(v, s, tmp_f);				\
			g = HSV0(v, s, tmp_f);				\
			b = HSV1(v, s, tmp_f);				\
			break;						\
									\
	     case 2:    r = HSV1(v, s, tmp_f);				\
			g = HSV0(v, s, tmp_f);				\
			b = HSV3(v, s, tmp_f);				\
			break;						\
									\
	     case 3:    r = HSV1(v, s, tmp_f);				\
			g = HSV2(v, s, tmp_f);				\
			b = HSV0(v, s, tmp_f);				\
			break;						\
									\
	     case 4:    r = HSV3(v, s, tmp_f);				\
			g = HSV1(v, s, tmp_f);				\
			b = HSV0(v, s, tmp_f);				\
			break;						\
									\
	     case 5:    r = HSV0(v, s, tmp_f);				\
			g = HSV1(v, s, tmp_f);				\
			b = HSV2(v, s, tmp_f);				\
			break;						\
	}								\
}

/*
 *  Convert  RGB_to_HLS()  - converts a Red, Green, Blue number
 *			     to a Hue, Light, Saturation one.
 */
#define  RGB_to_HLS(r, g, b, h, l, s)					\
{									\
	static double	maximum, minimum, tmp_r, tmp_g, tmp_b;		\
									\
	tmp_r = normalize(r);						\
	tmp_g = normalize(g);						\
	tmp_b = normalize(b);						\
	maximum = kmax(kmax(tmp_r, tmp_g), tmp_b);			\
	minimum = kmin(kmin(tmp_r, tmp_g), tmp_b);			\
									\
	l = (maximum + minimum)/2;					\
	if (maximum == minimum)						\
	   s = h = 0.0;							\
	else								\
	{								\
	   s = (maximum - minimum)/(maximum + minimum);			\
									\
	   if (tmp_r == maximum)					\
	      h = (maximum - tmp_b)/(maximum - minimum) -               \
		  (maximum - tmp_g)/(maximum - minimum); 		\
	   else if (tmp_g == maximum)					\
	      h = 2 + (maximum - tmp_r)/(maximum - minimum) - 	 	\
		  (maximum - tmp_b)/(maximum - minimum); 		\
	   else if (tmp_b == maximum)					\
	      h = 4 + (maximum - tmp_g)/(maximum - minimum) - 		\
		  (maximum - tmp_r)/(maximum - minimum); 		\
									\
	   h /= 6.0;							\
	   if (h < 0.0) h += 1.0;					\
	}								\
}


/*
 *  Convert  HLS_to_RGB()  - converts a Hue, Light, Saturation number
 *			     to a Red, Green, Blue one.
 */
#define  HLS_to_RGB(h, l, s, r, g, b)				\
{									\
	static int	tmp_i;						\
	static double	tmp_v, tmp_f, minimum, vsf;			\
									\
        tmp_v = l * (1.0 + s);						\
	if (s == 0.0)							\
	   r = g = b = normalize_rgb(l);				\
	else								\
	{								\
	   if (h < 0.0)							\
	      h += 1.0;							\
									\
	   tmp_i = (int) (h * 6.0);					\
	   tmp_f = (h * 6.0) - tmp_i;					\
									\
	   minimum = l * 2 - tmp_v;					\
	   vsf = (tmp_v - minimum) * tmp_f;				\
									\
	   switch (tmp_i)						\
	   {								\
	      case 0:	r = normalize_rgb(tmp_v);			\
			g = normalize_rgb(minimum + vsf);		\
			b = normalize_rgb(minimum);			\
			break;						\
									\
	      case 1:	r = normalize_rgb(tmp_v - vsf);			\
			g = normalize_rgb(tmp_v);			\
			b = normalize_rgb(minimum);			\
			break;						\
									\
	      case 2:	r = normalize_rgb(minimum);			\
			g = normalize_rgb(tmp_v);			\
			b = normalize_rgb(minimum + vsf);		\
			break;						\
									\
	      case 3:	r = normalize_rgb(minimum);			\
			g = normalize_rgb(tmp_v - vsf);			\
			b = normalize_rgb(tmp_v);			\
			break;						\
									\
	      case 4:	r = normalize_rgb(minimum + vsf);		\
			g = normalize_rgb(minimum);			\
			b = normalize_rgb(tmp_v);			\
			break;						\
									\
	      case 5:	r  = normalize_rgb(tmp_v);			\
			g = normalize_rgb(minimum);			\
			b = normalize_rgb(tmp_v - vsf);			\
			break;						\
									\
	   }								\
	}								\
}


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _colorspace_h_ */
/* Don't add after this point */
