 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: contains defines to pnm, Portable anymap
   >>>>		       file format.  Part of the pbmplus utilities
   >>>>		       provided by Jef Poskanzer.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jul 24, 1992 09:04
   >>>>
   >>>> Modifications: Converted from Khoros 1.0 in file_formats/pbm.h (MY)
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatafmt_pnm_h_
#define _kdatafmt_pnm_h_

/*
 *	The "pbm" image file format describes the format used by
 *	the pbm conversion routines.  The format was developed
 *	by Jef Poskanzer.
 *
 *	The pbm format is really three different formats; pbm, pgm, &
 *	ppm.  The formats correspond to bitmap, greymap, and pixmap
 *	formats.
 *
 *	The following structure is used by the conversion routines to read
 *	and write the pbm files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert pbm
 *	files to and from the viff format.
 */

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Defines used to indicate the type of pbm file.  PBM represents a
 *  bitmap image, PGM represents a greymap image, PPM represents a
 *  pixmap (24 bit color) image.
 */
#define	PBM	1
#define	PGM	2
#define	PPM	3


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _pnm {

	int type;			/* type of pbm image         */
	int raw;			/* image is in raw format    */

	int  width, height;		/* width and height of image */
	int  maxval;			/* maximum value of image    */
	int  hdr_length;		/* length of ascii header    */
	kaddr data;			/* image data		     */
} pnm;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* pnm.c */
pnm *pnm_read PROTO((char *));
int pnm_write PROTO((char *, pnm *));
pnm *pnm_fdread PROTO((int));
int pnm_fdwrite PROTO((int, pnm *));
int pnm_free PROTO((pnm *));
pnm *pnm_create PROTO((int, int, int, int));

#endif /* _kdatafmt_pnm_h_ */
/* Don't add after this point */
