 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: The "ascii" format describes the conversion
   >>>>		       used for the format:
   >>>>
   >>>>			   Ascii File Format
   >>>>
   >>>>	               The format was orignially developed by the
   >>>>		       company/persons:
   >>>>
   >>>>			   
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 14, 1993 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatafmt_ascii_h_
#define _kdatafmt_ascii_h_

/*
 *	The "ascii" image file format describes the format used by
 *	the Ascii File Format  conversion routines.  The format was developed
 *	by 
 *
 *	The following structure is used by the conversion routines to read
 *	and write the ascii files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert ascii
 *	files to and from the format.
 */

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _ascii {
	int  type;
	int  width;
	int  height;
	kaddr data;
} ascii;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

ascii   *ascii_readheader PROTO((int));
ascii   *ascii_read       PROTO((char *));
ascii   *ascii_fdread       PROTO((int));
ascii   *ascii_create     PROTO((void));
int     ascii_writeheader PROTO((int, ascii *));
int     ascii_write       PROTO((char *, ascii *));
int     ascii_fdwrite       PROTO((int, ascii *));
int     ascii_free        PROTO((ascii *));


#endif /* _kdatafmt_ascii_h_ */
/* Don't add after this point */
