#include <dataserv.h>

/*
 *  This is a simple canvas program that creates three glyphs
 *  according to the GUI's defined in the "images.pane", "putimage.pane",
 *  and "kadd.pane" UIS files in this directory.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
   kobject src = NULL;
   kobject dst = NULL;
   int     size[4];
   int     type;
   int     grid;

   double  w;
   double  h;
   double  d;
   
   if (argc != 3)
   {
      kerror(NULL, "main", "usage : example <oldfile> <newfile>");
      kexit(KEXIT_FAILURE);
   }

   /* -- open input and output data objects -- */
   if (argv[1] != NULL)
      src = kpds_open_input_object(argv[1]);
   if (argv[2] != NULL)
      dst = kpds_open_output_object(argv[2]);

   /* -- make sure we have valid data objects to work with -- */
   if (src == NULL)
   {
      kerror(NULL, "main", "unable to open input object");
      kexit(KEXIT_FAILURE);
   }

   if (dst == NULL)
   {
      kerror(NULL, "main", "unable to open output object");
      kexit(KEXIT_FAILURE);
   }

   /* -- at this point we have valid data objects -- */
   
   /* 
    *    Prior to Khoros 2.0.1, uniform location data consisted of
    *    the following attributes.  
    *
    *     "locationSize"         _PRES_LOCATION_SIZE      (integer[4])
    *     "presLocationSize"     _PHYS_LOCATION_SIZE      (integer[4])
    *     "locationDataType"     _PHYS_LOCATION_DATA_TYPE (integer)
    *     "presLocationDataType" _PRES_LOCATION_DATA_TYPE (integer)
    *     "locationGrid"         _INTERNAL_LOCATION_GRID  (integer)
    *     "locationBegin"        KPDS_LOCATION_BEGIN      (5 double arguments)
    *     "locationEnd"          KPDS_LOCATION_END        (5 double arguments)
    * 
    *    Since these attributes are 'invalid' according to the post
    *    2.0.1 polymorphic data services, we must retrieve these
    *    attributes through data management services.
    */

   /* -- first, make sure this viff has old location data -- */
   if (kdms_get_attribute(src, NULL, "locationGrid", &grid))
   {
      if (grid == KUNIFORM)
      {
	 /* -- if any of the old attributes exist, it's old -- */
	 if (!kdms_query_attribute(src, NULL, "locationSize",
				   NULL, NULL, NULL, NULL))
	 {
	    kerror(NULL, "main", "this program is used to convert ...");
	    kexit(KEXIT_FAILURE);
	 }
      }
      else
      {
	 kerror(NULL, "main", "this program is used to convert ...");
	 kexit(KEXIT_FAILURE);
      }
   }
   else
   {
      kerror(NULL, "main", "this program is used to convert ...");
      kexit(KEXIT_FAILURE);
   }

   /* -- by now, we know src contains old-style uniform location data -- */

   /* -- create new-style uniform location data in the destination -- */
   if (!kpds_set_attribute(dst, KPDS_LOCATION_GRID, KUNIFORM))
   {
      kerror(NULL, "main", "unable to set destination grid to uniform");
      kexit(KEXIT_FAILURE);
   }
   if (!kpds_create_location(dst))
   {
      kerror(NULL, "main", "unable to create destination location segment");
      kexit(KEXIT_FAILURE);
   }
   
   /* -- set the old uniform 'size' if present on the new destination -- */
   if (kdms_query_attribute(src, NULL, "presLocationSize", 
			    NULL, NULL, NULL, NULL))
   {
      if (!kdms_get_attribute(src, NULL, "presLocationSize", &size))
      {
	 kerror(NULL, "main", "unable to retrieve source location size");
	 kexit(KEXIT_FAILURE);
      }
      if (!kpds_set_attribute(dst, KPDS_LOCATION_SIZE, 
			      size[0], size[1], size[2], size[3]))
      {
	 kerror(NULL, "main", "unable to set destination location size");
	 kexit(KEXIT_FAILURE);
      }
   }

   /* -- set the old uniform 'datatype' if present on the new destination -- */
   if (kdms_query_attribute(src, NULL, "presLocationDataType", 
			    NULL, NULL, NULL, NULL))
   {
      if (!kdms_get_attribute(src, NULL, "presLocationDataType", &type))
      {
	 kerror(NULL, "main", "unable to retrieve source location data type");
	 kexit(KEXIT_FAILURE);
      }
      if (!kpds_set_attribute(dst, KPDS_LOCATION_DATA_TYPE, type))
      {
	 kerror(NULL, "main", "unable to set destination location data type");
	 kexit(KEXIT_FAILURE);
      }
   }
   
   /* -- set the old uniform 'begin' on the new destination -- */
   if (!kdms_get_attribute(src, NULL, "locationBegin", &w, &h, &d, NULL, NULL))
   {
      kerror(NULL, "main", "unable to retrieve source uniform begin");
      kexit(KEXIT_FAILURE);
   }
   if (!kpds_set_attribute(dst, KPDS_LOCATION_BEGIN, w, h, d)) 
   {
      kerror(NULL, "main", "unable to set destination uniform begin");
      kexit(KEXIT_FAILURE);
   }

   /* -- set the old uniform 'end' on the new destination -- */
   if (!kdms_get_attribute(src, NULL, "locationEnd", &w, &h, &d, NULL, NULL))
   {
      kerror(NULL, "main", "unable to retrieve source uniform end");
      kexit(KEXIT_FAILURE);
   }
   if (!kpds_set_attribute(dst, KPDS_LOCATION_BEGIN, w, h, d)) 
   {
      kerror(NULL, "main", "unable to set destination uniform end");
      kexit(KEXIT_FAILURE);
   }

   /* -- transfer the rest of the polymorphic data segments -- */

   /* -- transfer value data from src to dst if present -- */
   if (kpds_query_value(src))
   {
      if (!kpds_copy_value(src, dst, FALSE))  /* -- make a direct copy -- */
      {
	 kerror(NULL, "main", "unable to copy value data");
	 kexit(KEXIT_FAILURE);
      }
   }

   /* -- transfer mask data from src to dst if present -- */
   if (kpds_query_mask(src))
   {
      if (!kpds_copy_mask(src, dst, FALSE))  /* -- make a direct copy -- */
      {
	 kerror(NULL, "main", "unable to copy mask data");
	 kexit(KEXIT_FAILURE);
      }
   }

   /* -- transfer time data from src to dst if present -- */
   if (kpds_query_time(src))
   {
      if (!kpds_copy_time(src, dst, FALSE))  /* -- make a direct copy -- */
      {
	 kerror(NULL, "main", "unable to copy time data");
	 kexit(KEXIT_FAILURE);
      }
   } 

   /* -- transfer map data from src to dst if present -- */
   if (kpds_query_map(src))
   {
      if (!kpds_copy_map(src, dst, FALSE))  /* -- make a direct copy -- */
      {
	 kerror(NULL, "main", "unable to copy map data");
	 kexit(KEXIT_FAILURE);
      }
   } 

   kexit(KEXIT_SUCCESS);
}
