#! /bin/sh 

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="kstats"
file_name="test3.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------

tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"

test_num=1a
descr="stats of small object with map and value data (-w -h)"

cat <<EOF > $tmpdir/ascii.$$
1 2 3 4
0 3 5 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 2 -type byte -o $tmpdir/data.$$
cat <<EOF > $tmpdir/ascii.$$
47.5 0.036 1.45 87
37.5 0.36  1.05 8.7
49.5 2.036 3.45 67
27.8 0.6   8.5  7
7.5  6.036 0.45 8
0.5  0.3   1.4  0.87
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/data.$$ -wsize 4 -hsize 6 -type float -o $tmpdir/data.$$

kstats -i $tmpdir/data.$$ -w -h -o $tmpdir/stats.$$
report "$test_num" "$tmpdir/stats.$$" "test3.results/4x3v4x6m-wh.stats" "$descr" "1e-4"

test_num=1b
descr="stats of small object with map and value data (-whole)"
kstats -i $tmpdir/data.$$ -whole -o $tmpdir/stats.$$
report "$test_num" "$tmpdir/stats.$$" "test3.results/4x3v4x6m-whole.stats" "$descr" "1e-4"

/bin/rm $tmpdir/ascii.$$ $tmpdir/data.$$ $tmpdir/stats.$$

# ---------------------------------------------------------------

test_num=2a
descr="calculate stats of lizard with map and value data (-w -h)"
kstats -i $dpath/lizard.xv -o $tmpdir/stats.$$ -w -h
report "$test_num" "$tmpdir/stats.$$" "test3.results/lizard.wh.stats" "$descr" "1e-3"

test_num=2b
descr="calculate stats of lizard with map and value data (-whole)"
kstats -i $dpath/lizard.xv -o $tmpdir/stats.$$ -whole
report "$test_num" "$tmpdir/stats.$$" "test3.results/lizard.whole.stats" "$descr" "1e-4"

/bin/rm $tmpdir/stats.$$
# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
