#! /bin/sh 

echo "running test1.sh for kstats ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object 
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

if ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-4 -sat 1 -s -rt 1 -all
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set data path for image data, and temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  all stats:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=1
descr="all stats:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -all
report $test_num "$tmpdir/out.$$" "test1.results/ball.stats" "$descr"

# ------------------------------------------------------------------------
# Test  2:  all stats:  SAMPLEDATA/data/images/head.xv
# ------------------------------------------------------------------------
test_num=2
descr="all stats:  SAMPLEDATA/data/images/head.xv"
kstats -i $dpath/head.xv -o $tmpdir/out.$$ -all
report $test_num "$tmpdir/out.$$" "test1.results/head.stats" "$descr"

# ------------------------------------------------------------------------
# Test  3:  mean:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=3
descr="mean:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -mean
report $test_num "$tmpdir/out.$$" "test1.results/ball.mean" "$descr"

# ------------------------------------------------------------------------
# Test  4:  variance:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=4
descr="variance:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -var
report $test_num "$tmpdir/out.$$" "test1.results/ball.var" "$descr"

# ------------------------------------------------------------------------
# Test  5:  standard deviation:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=5
descr="standard deviation:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -sd
report $test_num "$tmpdir/out.$$" "test1.results/ball.sd" "$descr"

# ------------------------------------------------------------------------
# Test  6:  rms:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=6
descr="rms:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -rms
report $test_num "$tmpdir/out.$$" "test1.results/ball.rms" "$descr"

# ------------------------------------------------------------------------
# Test  7:  skew:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=7
descr="skew:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -skew
report $test_num "$tmpdir/out.$$" "test1.results/ball.skew" "$descr"

# ------------------------------------------------------------------------
# Test  8:  kurtosis:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=8
descr="kurtosis:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -kur
report $test_num "$tmpdir/out.$$" "test1.results/ball.kur" "$descr"

# ------------------------------------------------------------------------
# Test  9:  minval:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=9
descr="minval:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -minval
report $test_num "$tmpdir/out.$$" "test1.results/ball.minval" "$descr"

# ------------------------------------------------------------------------
# Test  10:  maxval:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=10
descr="maxval:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -maxval
report $test_num "$tmpdir/out.$$" "test1.results/ball.maxval" "$descr"

# ------------------------------------------------------------------------
# Test  11:  minval width coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=11
descr="minval width coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -wmin
report $test_num "$tmpdir/out.$$" "test1.results/ball.wmin" "$descr"

# ------------------------------------------------------------------------
# Test  12:  minval height coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=12
descr="minval height coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -hmin
report $test_num "$tmpdir/out.$$" "test1.results/ball.hmin" "$descr"

# ------------------------------------------------------------------------
# Test  13:  minval depth coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=13
descr="minval depth coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -dmin
report $test_num "$tmpdir/out.$$" "test1.results/ball.dmin" "$descr"

# ------------------------------------------------------------------------
# Test  14:  minval time coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=14
descr="minval time coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -tmin
report $test_num "$tmpdir/out.$$" "test1.results/ball.tmin" "$descr"

# ------------------------------------------------------------------------
# Test  15:  minval elements coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=15
descr="minval elements coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -emin
report $test_num "$tmpdir/out.$$" "test1.results/ball.emin" "$descr"

# ------------------------------------------------------------------------
# Test  16:  maxval width coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=16
descr="maxval width coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -wmax
report $test_num "$tmpdir/out.$$" "test1.results/ball.wmax" "$descr"

# ------------------------------------------------------------------------
# Test  17:  maxval height coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=17
descr="maxval height coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -hmax
report $test_num "$tmpdir/out.$$" "test1.results/ball.hmax" "$descr"

# ------------------------------------------------------------------------
# Test  18:  maxval depth coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=18
descr="maxval depth coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -dmax
report $test_num "$tmpdir/out.$$" "test1.results/ball.dmax" "$descr"

# ------------------------------------------------------------------------
# Test  19:  maxval time coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=19
descr="maxval time coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -tmax
report $test_num "$tmpdir/out.$$" "test1.results/ball.tmax" "$descr"

# ------------------------------------------------------------------------
# Test  20:  maxval elements coordinate:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=20
descr="maxval elements coordinate:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -emax
report $test_num "$tmpdir/out.$$" "test1.results/ball.emax" "$descr"

# ------------------------------------------------------------------------
# Test  21:  sum:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=21
descr="sum:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -sum
report $test_num "$tmpdir/out.$$" "test1.results/ball.sum" "$descr"

# ------------------------------------------------------------------------
# Test  22:  positive sum:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=22
descr="positive sum:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -psum
report $test_num "$tmpdir/out.$$" "test1.results/ball.psum" "$descr"

# ------------------------------------------------------------------------
# Test  23:  negative sum:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=23
descr="negative sum:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -nsum
report $test_num "$tmpdir/out.$$" "test1.results/ball.nsum" "$descr"

# ------------------------------------------------------------------------
# Test  24:  number contributing points:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=24
descr="number contributing points:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -pts
report $test_num "$tmpdir/out.$$" "test1.results/ball.pts" "$descr"

# ------------------------------------------------------------------------
# Test  25:  positive contributing points:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=25
descr="positive contributing points:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -ppts
report $test_num "$tmpdir/out.$$" "test1.results/ball.ppts" "$descr"

# ------------------------------------------------------------------------
# Test  26:  negative contributing points:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=26
descr="negative contributing points:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -npts
report $test_num "$tmpdir/out.$$" "test1.results/ball.npts" "$descr"

# ------------------------------------------------------------------------
# Test  27:  zero contributing points:  SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=27
descr="zero contributing points:  SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -zpts
report $test_num "$tmpdir/out.$$" "test1.results/ball.zpts" "$descr"

# ------------------------------------------------------------------------
# Test  28:  width of SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=28
descr="width of SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -wsize
report $test_num "$tmpdir/out.$$" "test1.results/ball.wsize" "$descr"

# ------------------------------------------------------------------------
# Test  29:  height of SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=29
descr="height of SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -hsize
report $test_num "$tmpdir/out.$$" "test1.results/ball.hsize" "$descr"

# ------------------------------------------------------------------------
# Test  30:  depth of SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=30
descr="depth of SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -dsize
report $test_num "$tmpdir/out.$$" "test1.results/ball.dsize" "$descr"

# ------------------------------------------------------------------------
# Test  31:  time size of SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=31
descr="time size of SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -tsize
report $test_num "$tmpdir/out.$$" "test1.results/ball.tsize" "$descr"

# ------------------------------------------------------------------------
# Test  32:  elements size of SAMPLEDATA/data/images/ball.xv
# ------------------------------------------------------------------------
test_num=32
descr="elements size of SAMPLEDATA/data/images/ball.xv"
kstats -i $dpath/ball.xv -o $tmpdir/out.$$ -esize
report $test_num "$tmpdir/out.$$" "test1.results/ball.esize" "$descr"

# ------------------------------------------------------------------------
# Test  33:  stats on each band of SAMPLEDATA/data/images/mandril.rgb.xv
# ------------------------------------------------------------------------
test_num=33
descr="stats on each band of SAMPLEDATA/data/images/mandril.rgb.xv"
kstats -i $dpath/mandril.rgb.xv -o $tmpdir/out.$$ -w -h
report $test_num "$tmpdir/out.$$" "test1.results/mandril.rgb.stats" "$descr"

/bin/rm -f $tmpdir/out.$$

exit $status
