#! /bin/sh
# This testsuite tests the impulse generator kimpulse. The testsuite compares
# the results of the kimpulse command against the expected results stored in
# the test1.results/ directory. Since kimpulse is a generator program, it
# geenrates only the value segment and hence there is no opportunity to test
# PDS for mask and map segment operations. 
# The way the code in kimpulse is structured there is a different section of 
# code for every daattype supported by kimpulse. Thus any testsuite should
# test those datatypes. In this testsuite I have tested for 8 differnet 
# datatypes and one error condition in lkimpulse. I've also tried to exercise
# as many combinations of number of impulses along a dimension, the impulse 
# spacing and the impulse offsets as I can think of.Another thing to note, In
# calling the kimpulse routines I have used some parmeter default values 
# without specifying them on the commandline. If the dfaults are changed
# the testsuite should be checked for correctness.

echo "running test1.sh for kimpulse ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/usr/tmp}

# ------------------------------------------------------------------------
# Test  1:  Unsigned byte impulse generation
# ------------------------------------------------------------------------
test_num=1
descr="Unsigned byte impulse generation"
kimpulse -o $tmpdir/out.$$ -wsize 8 -hsize 1 -dsize 4 -tsize 2 -wnum 8 -woff 4 -hoff 0 -doff 0 -toff 0 -eoff 0 -dnum 2 -wsp 1 -dsp 2 -bgreal 0 -fgreal 300
report $test_num "$tmpdir/out.$$" "test1.results/8x1ubytex4x2x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  Unsigned long impulse generation
# ------------------------------------------------------------------------
test_num=2
descr="Unsigned long impulse generation"
kimpulse -o $tmpdir/out.$$ -wsize 1 -hsize 1 -dsize 4 -tsize 4 -wnum 1 -dnum 4 -tnum 4 -hoff 0 -doff 0 -toff  0 -woff 0 -eoff 0 -wnum 7 -hnum 7 -dnum 7 -tnum 7 -enum 7 -wsp 1 -hsp 1 -fgreal 13 -type "unsigned long"
report $test_num "$tmpdir/out.$$" "test1.results/ulong1x1x4x4x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  Floating point impulse generation
# ------------------------------------------------------------------------
test_num=3
descr="Floating point impulse generation"
kimpulse -o $tmpdir/out.$$ -wsize 1 -hsize 1 -dsize 16 -wnum 1 -dnum 8 -doff 1 -woff 0 -toff 0 -hoff 0 -eoff 0 -dsp 2 -fgreal 123.45 -bgreal 54.321 -type "float"
report $test_num "$tmpdir/out.$$" "test1.results/fpt1x1x16x1x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  Bit impulse generation
# ------------------------------------------------------------------------
test_num=4
descr="Bit impulse generation"
#kimpulse -type "bit" -o $tmpdir/out.$$ -wsize 4 -hsize 4 -dsize 4 -fgreal 0.0 -bgreal 1.0
#report $test_num "$tmpdir/out.$$" "test1.results/bit4x4x4x1x1.viff" "$descr"
#/bin/rm -f $tmpdir/out.$$
echo "Commented out until bit is supported: Test  $test_num --> "$descr""

# ------------------------------------------------------------------------
# Test  5:  Long impulse generation
# ------------------------------------------------------------------------
test_num=5
descr="Long impulse generation"
kimpulse -type "long" -o $tmpdir/out.$$ -wsize 7 -hsize 1 -dsize 11 -wnum 5 -hnum 1 -dnum 11 -wsp 1 -hsp 1 -dsp 1 -woff 0 -hoff 0 -doff 0 -bgreal -10.0 -fgreal 11.0
report $test_num "$tmpdir/out.$$" "test1.results/long7x1x11x1x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  6:  Short impulse generation
# ------------------------------------------------------------------------
test_num=6
descr="Short impulse generation"
kimpulse -type "short" -o $tmpdir/out.$$ -wsize 1 -hsize 1 -dsize 1 -tsize 13 -esize 1 -wnum 1 -hnum 1 -tnum 4 -woff 0 -hoff 0 -wsp 1 -hsp 1 -tsp 3 -toff 2 -fgreal 4097
report $test_num "$tmpdir/out.$$" "test1.results/short1x1x1x13x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  7:  Unsigned integer generation
# ------------------------------------------------------------------------
test_num=7
descr="Unsigned integer generation"
kimpulse -type "unsigned integer" -o $tmpdir/out.$$ -wsize 1 -hsize 1 -dsize 7 -tsize 1  -esize 1 -wnum 1 -hnum 1 -dnum 3 -doff 0 -woff 0 -hoff 0 -wnum 1 -hnum 1  -dsp 2 -fgreal 10 -bgreal 100
report $test_num "$tmpdir/out.$$" "test1.results/uint1x1x7x1x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  8:  Double Complex impulse generation
# ------------------------------------------------------------------------
test_num=8
descr="Double Complex impulse generation"
kimpulse -type "double complex" -o $tmpdir/out.$$ -wsize 3 -hsize 1 -dsize 5 -tsize 7 -esize 1 -wnum 3 -woff 0 -wsp 1 -hoff 0 -hsp 1 -hnum 1 -dnum 3 -dsp 2 -doff 1 -tnum 8 -toff 4 -tsp 4 -bgreal 1.23 -bgimag 3.21 -fgreal -2.05 -fgimag -5.02
report $test_num "$tmpdir/out.$$" "test1.results/dcomplex3x1x5x7x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  9:  Error condition: Offset > Dimension size
# ------------------------------------------------------------------------
test_num=9
descr="Error condition: Offset > Dimension size"
kimpulse -type "complex" -o $tmpdir/out.$$ -wsize 1 -hsize 1 -dsize 16 -woff 1 -hoff 0 > $tmpdir/err.$$ 2>&1

if [ $? = 0 ]
then
   echo "Failed:  Test  $test_num --> "$test_descr""
   status=1
else
   echo "Passed:  Test  $test_num --> "$test_descr""
fi

/bin/rm -f $tmpdir/err.$$
exit $status
