#! /bin/sh

echo "running test1.sh for khistops ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  equalize unsigned byte input, no mask, no map, whole 
# ------------------------------------------------------------------------
test_num=1
descr="equalize - unsigned byte input, no mask, no map, whole"
cat <<EOF > $tmpdir/ascii.$$
1 2 3 4 5 6 7 8 9 0
2 3 4 5 6 7 8 9 0 1
1 2 1 2 1 2 1 2 1 2
1 20 2 20 3 20 20 20 20 20
1 2 3 4 5 6 7 8 9 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 5 -type 3 -o $tmpdir/ascii.$$
khistops -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -equalize -whole
cat <<EOF > $tmpdir/ascii.$$
61  107  127  143  158  173  189  204  219  15  
107 127  143  158  173  189  204  219  15   61  
61  107  61   107  61   107  61   107  61   107  
61  255  107  255  127  255  255  255  255  255  
61  107  127  143  158  173  189  204  219  15  
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 5 -type 3 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2:  equalize signed byte input, no mask, no map, whole
# ------------------------------------------------------------------------
test_num=2
descr="equalize - signed byte input, no mask, no map, whole"
cat <<EOF > $tmpdir/ascii.$$
1 2 3 4 5 6 7 8 9 0
2 3 4 5 6 7 8 9 0 1
1 2 1 2 1 2 1 2 1 2
1 -20 2 20 3 20 20 20 20 20
1 2 3 4 5 6 -7 8 9 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 5 -type 2 -o $tmpdir/ascii.$$
khistops -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -equalize -whole
cat <<EOF > $tmpdir/ascii.$$
-57  -11    10  25  40  56   66  81  96  -102
-11   10    25  40  56  66   81  96 -102  -57
-57  -11   -57 -11 -57 -11  -57 -11 -57   -11
-57  -123  -11 127  10  127 127 127 127   127
-57  -11    10  25  40  56 -118  81  96  -102
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 5 -type 2 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  3:  stretch unsigned short input, no mask, no map, rows
# ------------------------------------------------------------------------
test_num=3
descr="stretch - unsigned short input, no mask, no map, rows"
cat <<EOF > $tmpdir/ascii.$$
1 2 3 4 5 6 7 8 9 0
2 3 4 5 6 7 8 9 0 1
1 2 1 2 1 2 1 2 1 2
1 20 2 20 3 20 20 20 20 20
1 2 3 4 5 6 7 8 9 0
57 221 124 1024 0 83 62 8 25 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 6 -type 5 -o $tmpdir/ascii.$$
khistops -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -stretch -w
cat <<EOF > $tmpdir/ascii.$$
7281  14563  21845  29126  36408  43690  50971  58253  65535  0
14563  21845  29126  36408  43690  50971  58253  65535  0  7281
0  65535  0  65535  0  65535  0  65535  0  65535
0  65535  3449  65535  6898  65535  65535  65535  65535  65535
7281  14563  21845  29126  36408  43690  50971  58253  65535  0
3647  14143  7935  65535  0  5311  3967  511  1599  127
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 6 -type 5 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status

