#! /bin/sh

echo "running test1.sh for kgsin ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/usr/tmp}

# ------------------------------------------------------------------------
# Test  1:  Integer 3D sine wave (WxHxD)
# ------------------------------------------------------------------------
test_num=1
descr="Integer value sine wave (WxHxD)"
kgsin -o $tmpdir/out.$$ -wsize 3 -hsize 5 -dsize 7 -tsize 1 -type "integer" -sin1 -ampl -2.05 -wnum 0.0 -hnum 0.0 -dnum 0.0 -tnum 0.0 -enum 0.0 -wp 45
report $test_num "$tmpdir/out.$$" "test1.results/int3x5x7x1x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  Signed long 2D sine wave (TxE)
# ------------------------------------------------------------------------
test_num=2
descr="Signed long 2D sine wave (TxE)"
kgsin -o $tmpdir/out.$$ -wsize 1 -hsize 1 -dsize 3 -tsize 7 -sin5 -wampl 2.25 -hampl 2.41 -dampl -4.46 -tampl 1.0 -eampl 0.0 -type "long" -dnum 0.5 -tnum 2.0 -wp 15 -hp 40 -dp 15 -tp -15 -ep 45 
report $test_num "$tmpdir/out.$$" "test1.results/long1x1x3x7x1.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  Unsigned byte 3D sine wave (HxTxE)
# test 3 commented out because different architectures deal differently
# with unsigned byte.
# ------------------------------------------------------------------------
#test_num=3
#descr="Unsigned byte 3D sine wave (HxTxE)"
#kgsin -o $tmpdir/out.$$ -wsize 1 -hsize 2 -dsize 1 -tsize 8 -esize 7 -sin1 -ampl -330 -tnum 2.0 -enum 3.5 -type "unsigned byte" -tp 90.0 -ep 90.0 -hnum 1.0 -hp 90
#report $test_num "$tmpdir/out.$$" "test1.results/ubyte1x2x1x8x7.viff" "$descr"
#/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  Double complex 5D sine wave
# ------------------------------------------------------------------------
test_num=4
descr="Double complex 5D sine wave"
kgsin -o $tmpdir/out.$$ -wsize 2 -hsize 3 -dsize 4 -tsize 2 -esize 3 -sin5 -wampl 4.0 -hampl -4.0 -dampl 1.5 -tampl 0.0 -eampl 1.0 -wnum 2.0 -hnum 2.5 -dnum 0.0 -type "double complex" -wp 40 -hp 50 -dp -90 
report $test_num "$tmpdir/out.$$" "test1.results/dcomplex2x3x4x2x3.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  5: Complex 3D (WxDxE)
# ------------------------------------------------------------------------
test_num=5
descr="Complex 3D sine wave (WxDxE)"
kgsin -type "complex" -o $tmpdir/out.$$ -wsize 4 -hsize 1 -dsize 5 -tsize 1 -esize 7 -sin1 -ampl 24.8 -wnum 2.41 -hnum 4.94 -dnum 2.97 -tnum 0.5 -enum 0.5 
report $test_num "$tmpdir/out.$$" "test1.results/complex4x1x5x1x7.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

exit $status
