#! /bin/sh

echo "running test2.sh for kextract ... process ($$)"

# 8-29-94 - changed tolerance on test 1 from 1e-5 to 1e-4.  See discussion
# in header of karith2/test2.sh. - dk

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# tolerance value of 1e-5 recommended
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  mandril.rgb -woff 60 -hoff 30 -wsize 103 -hsize 35
# ------------------------------------------------------------------------
test_num=1
descr="mandril.rgb -woff 60 -hoff 30 -wsize 103 -hsize 35"
kextract -i $dpath/mandril.rgb.xv -o $tmpdir/out.$$ -woff 60 -hoff 30 -wsize 103 -hsize 35 -subpos FALSE
kstats -i $tmpdir/out.$$ -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "test2.results/stats.man.rgb_wo60_ho30_ws103_hs35" "$descr" "1e-4"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kextract -i ~mirage/khoros_core/data/images/mandril.rgb.xv -o junk -woff 60 -hoff 30 -wsize 103 -hsize 35 -subpos FALSE
# kstats -i junk -o stats
# ksegcmp -i1 stats -i2 test2.results/stats.man.rgb_w60_h30_wi103_he35

# ------------------------------------------------------------------------
# Test  2:  head -woff 100 -hoff -20 -wsize 20 
# ------------------------------------------------------------------------
test_num=2
descr="head -woff 100 -hoff -20 -wsize 20"
kextract -i $dpath/head.xv -o $tmpdir/out1.$$ -woff 100 -hoff -20 -wsize 20 -subpos FALSE
kextract -i $tmpdir/out1.$$ -o $tmpdir/out1.$$ -hoff 20 -subpos FALSE
kextract -i $dpath/head.xv -o $tmpdir/out2.$$ -woff 100 -wsize 20  -subpos FALSE
report $test_num "$tmpdir/out1.$$" "$tmpdir/out2.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out1.$$ $tmpdir/out2.$$
# to run, use following command line
# kextract -i ~mirage/khoros_core/data/images/head.xv -o junk1 -woff 100 -hoff -20 -wsize 20 -subpos FALSE
# kextract -i junk1 -o junk1 -hoff 20 -subpos FALSE
# kextract -i ~mirage/khoros_core/data/images/head.xv -o junk2 -woff 100 -wsize 20 -subpos FALSE
# ksegcmp -i1 junk1 -i2 junk2

# ------------------------------------------------------------------------
# Test  3:  head -wsize 300 -hsize 300, then -wsize 256 -hsize 228
# ------------------------------------------------------------------------
test_num=3
descr="head -wsize 300 -hsize 300, then -wsize 256 -hsize 228"
kextract -i $dpath/head.xv -o $tmpdir/out.$$ -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -wsize 300 -hsize 300 -tsize 1 -dsize 1 -esize 1 -subpos FALSE
kextract -i $tmpdir/out.$$ -o $tmpdir/out.$$ -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -wsize 256 -hsize 228 -tsize 1 -dsize 1 -esize 1 -subpos FALSE
report $test_num "$tmpdir/out.$$" "$dpath/head.xv" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ 
# to run, use following command line
# kextract -i image:head -o jnk -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -wsize 300 -hsize 300 -tsize 1 -dsize 1 -esize 1 -subpos FALSE
#  kextract -i jnk -o jnk2 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -wsize 256 -hsize 228 -tsize 1 -dsize 1 -esize 1 -subpos FALSE
# ksegcmp -i1 jnk2 -i2 image:head

exit $status
