#! /bin/sh 

echo "testing kcmplx  ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
datapath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  4x3cmplx.xv -conj
# ------------------------------------------------------------------------
test_num=1
kcmplx -i $datapath/4x3cmplx.xv -o $tmpdir/conj.$$ -conj
descr="conjugate output:  4x3cmplx.xv"
report $test_num "$tmpdir/conj.$$" "test1.results/4x3conj" "$descr"
/bin/rm -f $tmpdir/conj.$$

# ------------------------------------------------------------------------
# Test  2:  4x3cmplx.xv -r2p
# ------------------------------------------------------------------------
test_num=2
kcmplx -i $datapath/4x3cmplx.xv -o $tmpdir/r2p.$$ -r2p
descr="rectangular to polar output:  4x3cmplx.xv"
report $test_num "$tmpdir/r2p.$$" "test1.results/4x3r2p" "$descr"
/bin/rm -f $tmpdir/r2p.$$

# ------------------------------------------------------------------------
# Test  3:  4x3cmplx.xv -p2r
# ------------------------------------------------------------------------
test_num=3
kcmplx -i $datapath/4x3cmplx.xv -o $tmpdir/p2r.$$ -p2r
descr="polar to rectangular output:  4x3cmplx.xv"
report $test_num "$tmpdir/p2r.$$" "test1.results/4x3p2r" "$descr"
/bin/rm -f $tmpdir/p2r.$$

# ------------------------------------------------------------------------
# Test  4:  2x3.c.xv -conj
# ------------------------------------------------------------------------
test_num=4
kcmplx -i $datapath/2x3.c.xv -o $tmpdir/conj.$$ -conj
descr="conjugate output:  2x3.c.xv"
report $test_num "$tmpdir/conj.$$" "test1.results/2x3conj" "$descr"
/bin/rm -f $tmpdir/conj.$$

# ------------------------------------------------------------------------
# Test  5:  2x3.c.xv -r2p
# ------------------------------------------------------------------------
test_num=5
kcmplx -i $datapath/2x3.c.xv -o $tmpdir/r2p.$$ -r2p
descr="rectangular to polar output:  2x3.c.xv"
report $test_num "$tmpdir/r2p.$$" "test1.results/2x3r2p" "$descr"
/bin/rm -f $tmpdir/r2p.$$

# ------------------------------------------------------------------------
# Test  6:  2x3.c.xv -p2r
# ------------------------------------------------------------------------
test_num=6
kcmplx -i $datapath/2x3.c.xv -o $tmpdir/p2r.$$ -p2r
descr="polar to rectangular output:  2x3.c.xv"
report $test_num "$tmpdir/p2r.$$" "test1.results/2x3p2r" "$descr"
/bin/rm -f $tmpdir/p2r.$$

# ------------------------------------------------------------------------
# Test  7:  7x1ival_7x1dcmap.viff -conj
# ------------------------------------------------------------------------
test_num=7
kcmplx -i $datapath/7x1ival_7x1dcmap.viff -o $tmpdir/conj.$$ -conj
descr="conjugate output:  7x1ival_7x1dcmap.viff"
report $test_num "$tmpdir/conj.$$" "test1.results/7x1conj" "$descr"
/bin/rm -f $tmpdir/conj.$$

# ------------------------------------------------------------------------
# Test  8:  7x1ival_7x1dcmap.viff -r2p
# ------------------------------------------------------------------------
test_num=8
kcmplx -i $datapath/7x1ival_7x1dcmap.viff -o $tmpdir/r2p.$$ -r2p
descr="rectangular to polar output:  7x1ival_7x1dcmap.viff"
report $test_num "$tmpdir/r2p.$$" "test1.results/7x1r2p" "$descr"
/bin/rm -f $tmpdir/r2p.$$

# ------------------------------------------------------------------------
# Test  9:  7x1ival_7x1dcmap.viff -p2r
# ------------------------------------------------------------------------
test_num=9
kcmplx -i $datapath/7x1ival_7x1dcmap.viff -o $tmpdir/p2r.$$ -p2r
descr="polar to rectangular output:  7x1ival_7x1dcmap.viff"
report $test_num "$tmpdir/p2r.$$" "test1.results/7x1p2r" "$descr"
/bin/rm -f $tmpdir/p2r.$$

exit $status
