#! /bin/sh 

echo "running test1.sh for kaxis ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  2x3mask.byte.viff -wh -hw (mask only) 
# ------------------------------------------------------------------------
test_num=1
descr="2x3mask.byte.viff -wh -hw (mask only)"
kaxis -i $dpath/2x3mask.byte.viff -o $tmpdir/out.$$ -wh -hw
report $test_num "$tmpdir/out.$$" "test1.results/2x3vm_wh_hw" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  switch width and height axes on 3x4.double.viff 
# ------------------------------------------------------------------------
test_num=2
descr="switch width and height axes on 3x4.double.viff"
kaxis -i $dpath/3x4.double.viff -o $tmpdir/out.$$ -wh -hw
report $test_num "$tmpdir/out.$$" "test1.results/3x4.d_wh_hw" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  w6h5d4t3e2.val.float.viff -wd -dh -hw (value data)
# ------------------------------------------------------------------------
test_num=3
descr="w6h5d4t3e2.val.float.viff -wd -dh -hw (value data)"
kaxis -i $dpath/w6h5d4t3e2.val.float.viff -o $tmpdir/out.$$ -wd -dh -hw
report $test_num "$tmpdir/out.$$" "test1.results/w6h5d4t3e2fv_wd_dh_hw" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  w6h5d4t3e2.fval.floc.viff -wd -dh -hw (location and value data)
# ------------------------------------------------------------------------
test_num=4
descr="w6h5d4t3e2.fval.floc.viff -wd -dh -hw (location and value data)"
kaxis -i $dpath/w6h5d4t3e2.fval.floc.viff -o $tmpdir/out.$$ -wd -dh -hw
report $test_num "$tmpdir/out.$$" "test1.results/w6h5d4t3e2fvfl_wd_dh_hw" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  5:  3x4masked.double.viff -wh (value and mask data)
# ------------------------------------------------------------------------
test_num=5
descr="3x4masked.double.viff -wh (value and mask data)"
kaxis -i $dpath/3x4masked.double.viff -o $tmpdir/out.$$ -wh
report $test_num "$tmpdir/out.$$" "test1.results/3x4mdv_wh" "$descr"
/bin/rm -f $tmpdir/out.$$


exit $status
