#! /bin/sh

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="kappend"
file_name="test3.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------

# ---------------------------------------------------------------
# mask tests:
# 8 inputs, 3 have masks, append along all dimensions (kappend vs kinset)
# ---------------------------------------------------------------
echo "Mask Tests: 8 inputs, 3 have masks, different sizes"

tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/sequences/numbers/xbm.0-9"
# input data setup - add masks to data
kcpfromval -i $dpath/mask.00 -o $tmpdir/data0.$$ -mask
kinsertseg -i1 $tmpdir/data0.$$ -i2 $dpath/image.00 -mask -o $tmpdir/data0.$$
kcpfromval -i $dpath/mask.02 -o $tmpdir/data2.$$ -mask
kinsertseg -i1 $tmpdir/data2.$$ -i2 $dpath/image.02 -mask -o $tmpdir/data2.$$
kcpfromval -i $dpath/mask.05 -o $tmpdir/data5.$$ -mask
kinsertseg -i1 $tmpdir/data5.$$ -i2 $dpath/image.05 -mask -o $tmpdir/data5.$$

kresample -i $tmpdir/data0.$$ -wmag 2 -o $tmpdir/data0.$$
kresample -i $dpath/image.03 -wmag .5 -hmag .75 -o $tmpdir/data3.$$

# -- Test 1 --> 8 inputs, 3 have masks, append along w (kappend vs kinset)
test_num=1
descr="8 inputs, 3 have masks, append along w (kappend vs kinset)"

kappend -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -i3 $tmpdir/data2.$$ \
	-i4 $tmpdir/data3.$$ -i5 $dpath/image.04 -i6 $tmpdir/data5.$$ \
	-i7 $dpath/image.06  -o $tmpdir/append.$$ -w
kinset -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -woff 130 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data2.$$ -woff 195 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data3.$$ -woff 260 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.04 -woff 293 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data5.$$ -woff 358 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.06 -woff 423 \
	-o $tmpdir/inset.$$ -insetvalid 0
report $test_num "$tmpdir/append.$$" "$tmpdir/inset.$$" "$descr" "1e-5"

# -- Test 2 --> 8 inputs, 3 have masks, append along e (kappend vs kinset)
test_num=2
descr="8 inputs, 3 have masks, append along e (kappend & kinset)"
kappend -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -i3 $tmpdir/data2.$$ \
	-i4 $tmpdir/data3.$$ -i5 $dpath/image.04 -i6 $tmpdir/data5.$$ \
	-i7 $dpath/image.06  -o $tmpdir/append.$$ -e
kinset -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -eoff 1 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data2.$$ -eoff 2 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data3.$$ -eoff 3 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.04 -eoff 4 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data5.$$ -eoff 5 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.06 -eoff 6 \
	-o $tmpdir/inset.$$ -insetvalid 0
report $test_num "$tmpdir/append.$$" "$tmpdir/inset.$$" "$descr" "1e-5"

# -- Test 3 --> 8 inputs, 3 have masks, append along d (kappend vs kinset)
test_num=3
descr="8 inputs, 3 have masks, append along d (kappend & kinset)"
kappend -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -i3 $tmpdir/data2.$$ \
	-i4 $tmpdir/data3.$$ -i5 $dpath/image.04 -i6 $tmpdir/data5.$$ \
	-i7 $dpath/image.06  -o $tmpdir/append.$$ -d
kinset -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -doff 1 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data2.$$ -doff 2 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data3.$$ -doff 3 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.04 -doff 4 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data5.$$ -doff 5 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.06 -doff 6 \
	-o $tmpdir/inset.$$ -insetvalid 0
report $test_num "$tmpdir/append.$$" "$tmpdir/inset.$$" "$descr" "1e-5"

# -- Test 4 --> 8 inputs, 3 have masks, append along t (kappend vs kinset)
test_num=4
descr="8 inputs, 3 have masks, append along t (kappend & kinset)"
kappend -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -i3 $tmpdir/data2.$$ \
	-i4 $tmpdir/data3.$$ -i5 $dpath/image.04 -i6 $tmpdir/data5.$$ \
	-i7 $dpath/image.06  -o $tmpdir/append.$$ -t
kinset -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -toff 1 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data2.$$ -toff 2 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data3.$$ -toff 3 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.04 -toff 4 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data5.$$ -toff 5 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.06 -toff 6 \
	-o $tmpdir/inset.$$ -insetvalid 0
report $test_num "$tmpdir/append.$$" "$tmpdir/inset.$$" "$descr" "1e-5"

# -- Test 5 --> 8 inputs, 3 have masks, append along h (kappend vs kinset)
test_num=5
descr="8 inputs, 3 have masks, append along h (kappend & kinset)"
kappend -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -i3 $tmpdir/data2.$$ \
	-i4 $tmpdir/data3.$$ -i5 $dpath/image.04 -i6 $tmpdir/data5.$$ \
	-i7 $dpath/image.06  -o $tmpdir/append.$$ -h
kinset -i1 $tmpdir/data0.$$ -i2 $dpath/image.01 -hoff 65 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data2.$$ -hoff 130 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data3.$$ -hoff 195 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.04 -hoff 244 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $tmpdir/data5.$$ -hoff 309 \
	-o $tmpdir/inset.$$ -insetvalid 0
kinset -i1 $tmpdir/inset.$$ -i2 $dpath/image.06 -hoff 374 \
	-o $tmpdir/inset.$$ -insetvalid 0
report $test_num "$tmpdir/append.$$" "$tmpdir/inset.$$" "$descr" "1e-5"

/bin/rm -f $tmpdir/data0.$$ $tmpdir/data2.$$ $tmpdir/data3.$$ $tmpdir/data5.$$
/bin/rm -f $tmpdir/append.$$ $tmpdir/inset.$$

# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
