#! /bin/sh

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="kappend"
file_name="test1.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------

echo "General Tests:"

# Build data1 - 3w 2h 2e unsigned byte value 
cat <<EOF > $tmpdir/ascii.$$
100  101  102
110  111  112
200  201  202
210  211  212
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -esize 2 \
	 -type "unsigned byte" -o $tmpdir/data1.$$

# Build data2 - 3w 2t int
cat <<EOF > $tmpdir/ascii.$$
20 21 22
23 24 25
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -tsize 2 -type int -o $tmpdir/data2.$$

# Build data3 - 3h 2e float value
cat <<EOF > $tmpdir/ascii.$$
30 31 32
33 34 35
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 3 -esize 2 -type byte -o $tmpdir/data3.$$

# Build data4 - 3w 2h byte value 
cat <<EOF > $tmpdir/ascii.$$
40 41 42
43 44 45
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/data4.$$

# Build prepend answer for -i1 data1 -i2 data2 -i3 data3 -i4 data4
cat <<EOF > $tmpdir/ascii.$$
20 21 22   30   40 41 42   100  101  102
0  0  0    31   43 44 45   110  111  112
0  0  0    32    0  0  0     0    0    0

23 24 25   0     0  0  0     0    0    0
0  0  0    0     0  0  0     0    0    0
0  0  0    0     0  0  0     0    0    0

0  0  0    33    0  0  0   200  201  202
0  0  0    34    0  0  0   210  211  212
0  0  0    35    0  0  0     0    0    0

0  0  0     0    0  0  0     0    0    0
0  0  0     0    0  0  0     0    0    0
0  0  0     0    0  0  0     0    0    0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 3 -tsize 2 -esize 2 \
	 -type int -o $tmpdir/answer.$$

# ---------------------------------------------------------------
# data1 - 3w 2h 2e unsigned byte value 
# data2 - 3w 2t int
# data3 - 3h 2e float value
# data4 - 3w 2h byte value 
# ---------------------------------------------------------------

test_num=1
descr="prepend along w, objects of different sizes & data types"

kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-i4 $tmpdir/data4.$$ -o $tmpdir/out.$$ -w -append 0
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

/bin/rm -f $tmpdir/ascii.$$ $tmpdir/data1.$$ $tmpdir/data2.$$ $tmpdir/data3.$$
/bin/rm -f $tmpdir/data4.$$ $tmpdir/out.$$ $tmpdir/answer.$$

# ---------------------------------------------------------------
# Test 2:  stats along w,h planes of baby appended to ball along w
# ---------------------------------------------------------------
test_num=2a
descr="stats along w,h planes of baby appended to ball along w"

# verify by extracting and seg comparing against original.

kappend -i1 image:ball -i2 sequence:baby -o $tmpdir/out.$$ -w 
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -w -h 
report $test_num "$tmpdir/stats.$$" "test1.results/ballbaby.w.stats" \
		 "$descr" "1e-3"

test_num=2b
descr="extract ball & compare to original"
kextract -i $tmpdir/out.$$ -wsize 512 -hsize 512 -esize 1 -o $tmpdir/extract.$$
report $test_num "$tmpdir/extract.$$" "image:ball" "$descr" "1e-5"

test_num=2c
descr="extract baby & compare to original (location removed)"
kextract -i $tmpdir/out.$$ -woff 512 -hsize 192 -o $tmpdir/extract.$$
krmseg -i sequence:baby -o $tmpdir/babylessloc.$$  -loc
report $test_num "$tmpdir/extract.$$" "$tmpdir/babylessloc.$$" "$descr" "1e-5"

# ---------------------------------------------------------------
# Test 3:  stats along w,h planes of baby appended to ball along e
# ---------------------------------------------------------------
test_num=3a
descr="stats along w,h planes of baby appended to ball along e"

# verify by extracting and seg comparing against original.

kappend -i1 image:ball -i2 sequence:baby -o $tmpdir/out.$$ -e
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -w -h 
report $test_num "$tmpdir/stats.$$" "test1.results/ballbaby.e.stats" \
		 "$descr" "1e-4"
test_num=3b
descr="extract ball & compare to original"
kextract -i $tmpdir/out.$$ -esize 1 -o $tmpdir/extract.$$
report $test_num "$tmpdir/extract.$$" "image:ball" "$descr" "1e-5"

test_num=3c
descr="extract baby & compare to original (location removed)"
kextract -i $tmpdir/out.$$ -eoff 1 -wsize 250 -hsize 192 -o $tmpdir/extract.$$
krmseg -i sequence:baby -o $tmpdir/babylessloc.$$  -loc
report $test_num "$tmpdir/extract.$$" "$tmpdir/babylessloc.$$" "$descr" "1e-5"

/bin/rm $tmpdir/out.$$ $tmpdir/stats.$$ $tmpdir/extract.$$ 
/bin/rm $tmpdir/babylessloc.$$

# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
