 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kwiener.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kwiener_get_args
| 
|       Purpose: Gets command line args for kwiener
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kwiener
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kwiener_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kwiener is out of sync with arguments specified in kwiener's *.pane file; please rerun ghostwriter on kwiener.";


	/*
	 * allocate the kwiener structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kwiener_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kwiener_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "w",
			  &(clui_info->w_double),
			  &(clui_info->w_flag))))
	{
	    kerror(NULL, "kwiener_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kwiener_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



