 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kwiener
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kwiener_h_
#define _kwiener_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kwiener/uis/kwiener.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  source data object (FFT) (required infile)
 */
char	*i1_file;	/* source data object (FFT) FILENAME */
int	 i1_flag;	/* source data object (FFT) FLAG */

/*
 *  PSF data object (FFT) (required infile)
 */
char	*i2_file;	/* PSF data object (FFT) FILENAME */
int	 i2_flag;	/* PSF data object (FFT) FLAG */

/*
 *  filtered data object (FFT) (required outfile)
 */
char	*o_file;	/* filtered data object (FFT) FILENAME */
int	 o_flag;	/* filtered data object (FFT) FLAG */

/*
 *  Wiener parameter (optional double)
 */
double	 w_double;	/* Wiener parameter DOUBLE */
int	 w_flag;   	/* Wiener parameter FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kwiener_get_args PROTO((kform *));
void kwiener_usage_additions PROTO((void));
void kwiener_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
