 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for ksegcmp
   >>>> 
   >>>>    Written By: Steve Kubica
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ksegcmp_h_
#define _ksegcmp_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "ksegops/ksegops.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/ksegcmp/uis/ksegcmp.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  first input data object (required infile)
 */
char	*i1_file;	/* first input data object FILENAME */
int	 i1_flag;	/* first input data object FLAG */

/*
 *  second input data object (required infile)
 */
char	*i2_file;	/* second input data object FILENAME */
int	 i2_flag;	/* second input data object FLAG */

/*
 *  cast data to common type before comparing (optional flag)
 */
int	 cast_flag;  	/* cast data to common type before comparing FLAG */

/*
 *  tolerance for data comparison (optional double)
 */
double	 tol_double;	/* tolerance for data comparison DOUBLE */
int	 tol_flag;   	/* tolerance for data comparison FLAG */

/*
 *  compare segment level attributes (optional logical)
 */
int	 sat_logic;	/* compare segment level attributes LOGIC */
int	 sat_flag;  	/* compare segment level attributes FLAG */

/*
 *  compare object level attributes (optional logical)
 */
int	 oat_logic;	/* compare object level attributes LOGIC */
int	 oat_flag;  	/* compare object level attributes FLAG */

/*
 *  silent running - do not print to stdout (optional flag)
 */
int	 s_flag;  	/* silent running - do not print to stdout FLAG */

/*
 *  print difference summary (optional logical)
 */
int	 psum_logic;	/* print difference summary LOGIC */
int	 psum_flag;  	/* print difference summary FLAG */

/*
 *  print the position of differing points (optional flag)
 */
int	 pos_flag;  	/* print the position of differing points FLAG */

/*
 *  print value from first input for differing points (optional flag)
 */
int	 i1val_flag;  	/* print value from first input for differing points FLAG */

/*
 *  print data type of first input for differing points (optional flag)
 */
int	 i1type_flag;  	/* print data type of first input for differing points FLAG */

/*
 *  print value from second input for differing points (optional flag)
 */
int	 i2val_flag;  	/* print value from second input for differing points FLAG */

/*
 *  print data type of second input for differing points (optional flag)
 */
int	 i2type_flag;  	/* print data type of second input for differing points FLAG */

/*
 *  output ASCII file for summary (optional outfile)
 */
char	*o_file;	/* output ASCII file for summary FILENAME */
int	 o_flag;	/* output ASCII file for summary FLAG */

/*
 *  return results as exit status (optional logical)
 */
int	 rt_logic;	/* return results as exit status LOGIC */
int	 rt_flag;  	/* return results as exit status FLAG */

/*
 *  return results to Cantata  (optional string)
 */
char	*var_string;	/* return results to Cantata  STRING */
int	 var_flag;   	/* return results to Cantata  FLAG */

/*----- optional ME group ----*/
/*
 *  compare all data segments (optional flag)
 */
int	 all_flag;  	/* compare all data segments FLAG */

	/*---- nested optional   group ----*/
/*
 *  compare value segments (optional flag)
 */
int	 val_flag;  	/* compare value segments FLAG */

/*
 *  compare mask segments (optional flag)
 */
int	 mask_flag;  	/* compare mask segments FLAG */

/*
 *  compare location segments (optional flag)
 */
int	 loc_flag;  	/* compare location segments FLAG */

/*
 *  compare time segments (optional flag)
 */
int	 time_flag;  	/* compare time segments FLAG */

/*
 *  compare map segments (optional flag)
 */
int	 map_flag;  	/* compare map segments FLAG */

/*
 *  explicit segment name to compare (optional string)
 */
char	*segment_string;	/* explicit segment name to compare STRING */
int	 segment_flag;   	/* explicit segment name to compare FLAG */

	/*-- nested optional   group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void ksegcmp_get_args PROTO((kform *));
void ksegcmp_usage_additions PROTO((void));
void ksegcmp_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
