 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for ksampline
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ksampline_h_
#define _ksampline_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/ksampline/uis/ksampline.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input data object (required infile)
 */
char	*i_file;	/* input data object FILENAME */
int	 i_flag;	/* input data object FLAG */

/*
 *  output data object (required outfile)
 */
char	*o_file;	/* output data object FILENAME */
int	 o_flag;	/* output data object FLAG */

/*
 *  coordinate of start of line along W axis (optional double)
 */
double	 wc1_double;	/* coordinate of start of line along W axis DOUBLE */
int	 wc1_flag;   	/* coordinate of start of line along W axis FLAG */

/*
 *  coordinate of end of line along W axis (optional double)
 */
double	 wc2_double;	/* coordinate of end of line along W axis DOUBLE */
int	 wc2_flag;   	/* coordinate of end of line along W axis FLAG */

/*
 *  coordinate of start of line along H axis (optional double)
 */
double	 hc1_double;	/* coordinate of start of line along H axis DOUBLE */
int	 hc1_flag;   	/* coordinate of start of line along H axis FLAG */

/*
 *  coordinate of end of line along H axis (optional double)
 */
double	 hc2_double;	/* coordinate of end of line along H axis DOUBLE */
int	 hc2_flag;   	/* coordinate of end of line along H axis FLAG */

/*
 *  coordinate of start of line along D axis (optional double)
 */
double	 dc1_double;	/* coordinate of start of line along D axis DOUBLE */
int	 dc1_flag;   	/* coordinate of start of line along D axis FLAG */

/*
 *  coordinate of end of line along D axis (optional double)
 */
double	 dc2_double;	/* coordinate of end of line along D axis DOUBLE */
int	 dc2_flag;   	/* coordinate of end of line along D axis FLAG */

/*
 *  coordinate of start of line along T axis (optional double)
 */
double	 tc1_double;	/* coordinate of start of line along T axis DOUBLE */
int	 tc1_flag;   	/* coordinate of start of line along T axis FLAG */

/*
 *  coordinate of end of line along T axis (optional double)
 */
double	 tc2_double;	/* coordinate of end of line along T axis DOUBLE */
int	 tc2_flag;   	/* coordinate of end of line along T axis FLAG */

/*
 *  coordinate of start of line along E axis (optional double)
 */
double	 ec1_double;	/* coordinate of start of line along E axis DOUBLE */
int	 ec1_flag;   	/* coordinate of start of line along E axis FLAG */

/*
 *  coordinate of end of line along E axis (optional double)
 */
double	 ec2_double;	/* coordinate of end of line along E axis DOUBLE */
int	 ec2_flag;   	/* coordinate of end of line along E axis FLAG */

/*
 *  number of samples (including endpoints) (optional integer)
 */
int	 n_int; 	/* number of samples (including endpoints) INT */
int	 n_flag;	/* number of samples (including endpoints) FLAG */

/*
 *  minimum required neighbor count (optional integer)
 */
int	 nc_int; 	/* minimum required neighbor count INT */
int	 nc_flag;	/* minimum required neighbor count FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void ksampline_get_args PROTO((kform *));
void ksampline_usage_additions PROTO((void));
void ksampline_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
