 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kreplace
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kreplace.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Replace All Occurrences of X with Y
|
|       Purpose: main program for kreplace
|
|         Input:
|		char *clui_info->i_file; {Input file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		double clui_info->oval_double; {Value to be replaced (X)}
|		int    clui_info->oval_flag; {TRUE if -oval specified}
|
|		double clui_info->nval_double; {New value to be substituted (Y)}
|		int    clui_info->nval_flag; {TRUE if -nval specified}
|
|		char *clui_info->o_file; {Output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->utol_double; {Upper tolerance allowed in searched value}
|		int    clui_info->utol_flag; {TRUE if -utol specified}
|
|		double clui_info->ltol_double; {Lower tolerance allowed in searched value}
|		int    clui_info->ltol_flag; {TRUE if -ltol specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner, Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject   inp_obj;
        kobject   out_obj;
        int       upper_tol_flag;
        int       lower_tol_flag;
        double    old_val;
        double    new_val;
        double    upper_tol, lower_tol;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kreplace_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kreplace",
		kreplace_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kreplace_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((inp_obj = kpds_open_input_object(clui_info->i_file)) == NULL)
           kexit(KEXIT_FAILURE);

        if ((out_obj = kpds_open_output_object(
                       clui_info->o_file)) == NULL)
           kexit(KEXIT_FAILURE);

        old_val = clui_info->oval_double;
        new_val = clui_info->nval_double;

        upper_tol_flag = clui_info->utol_flag;
        lower_tol_flag = clui_info->ltol_flag; 

        upper_tol = clui_info->utol_double;
        lower_tol = clui_info->ltol_double;

        if (!kpds_copy_object_attr(inp_obj,out_obj))
	{
	   kerror("kreplace", "main", 
		  "Unable to copy attributes from source to destination.");
	   kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if ( !lkreplace(inp_obj,NULL,old_val,new_val,
                           upper_tol_flag,upper_tol,
                           lower_tol_flag,lower_tol,
                           out_obj))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kreplace", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(inp_obj,out_obj))
	{
	   kerror("kreplace", "main", 
		  "Unable to copy remaining data from source to destination.");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(inp_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kreplace_usage_additions
| 
|       Purpose: Prints usage additions in kreplace_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kreplace
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kreplace_usage_additions(void)
{
	kfprintf(kstderr, "\tReplace All Occurrences of X with Y\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kreplace_free_args
| 
|       Purpose: Frees CLUI struct allocated in kreplace_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kreplace
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kreplace_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
