 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kprval.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kprval_get_args
| 
|       Purpose: Gets command line args for kprval
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kprval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kprval_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kprval is out of sync with arguments specified in kprval's *.pane file; please rerun ghostwriter on kprval.";


	/*
	 * allocate the kprval structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "mapdata",
			  &(clui_info->mapdata_logic),
			  &(clui_info->mapdata_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "woff",
			  &(clui_info->woff_int),
			  &(clui_info->woff_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hoff",
			  &(clui_info->hoff_int),
			  &(clui_info->hoff_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "doff",
			  &(clui_info->doff_int),
			  &(clui_info->doff_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "toff",
			  &(clui_info->toff_int),
			  &(clui_info->toff_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "eoff",
			  &(clui_info->eoff_int),
			  &(clui_info->eoff_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "var",
			  &(clui_info->var_string),
			  &(clui_info->var_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "val",
			  &(clui_info->val_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "map",
			  &(clui_info->map_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mask",
			  &(clui_info->mask_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "time",
			  &(clui_info->time_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "loc",
			  &(clui_info->loc_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dimoff",
			  &(clui_info->dimoff_int),
			  &(clui_info->dimoff_flag))))
	{
	    kerror(NULL, "kprval_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



