 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kpad
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kpad.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Pad Data with a Constant Value
|
|       Purpose: main program for kpad
|
|         Input:
|		char *clui_info->i_file; {Input data file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->wsize_int; {Size of width dimension after padding}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Size of height dimension after padding}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->dsize_int; {Size of depth dimension after padding}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int clui_info->tsize_int; {Size of time dimension after padding}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int clui_info->esize_int; {Size of element dimension after padding}
|		int clui_info->esize_flag; {TRUE if -esize specified}
|
|		int clui_info->woff_int; {Offset of original object in width dimension}
|		int clui_info->woff_flag; {TRUE if -woff specified}
|
|		int clui_info->hoff_int; {Offset of original object in height dimension}
|		int clui_info->hoff_flag; {TRUE if -hoff specified}
|
|		int clui_info->doff_int; {Offset of original object in depth dimension}
|		int clui_info->doff_flag; {TRUE if -doff specified}
|
|		int clui_info->toff_int; {Offset of original object in time dimension}
|		int clui_info->toff_flag; {TRUE if -toff specified}
|
|		int clui_info->eoff_int; {Offset of original object in elements dimension}
|		int clui_info->eoff_flag; {TRUE if -eoff specified}
|
|		double clui_info->real_double; {Real part of pad constant}
|		int    clui_info->real_flag; {TRUE if -real specified}
|
|		double clui_info->imag_double; {Imaginary part of pad constant}
|		int    clui_info->imag_flag; {TRUE if -imag specified}
|
|		int clui_info->valid_logic; {Identify data added by kpad as valid/invalid in mask}
|		int clui_info->valid_flag; {TRUE if -valid specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner & Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject  in_obj, out_obj;
	int	 w_in, h_in, d_in, t_in, e_in;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kpad_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kpad",
		kpad_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kpad_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID) 
        {
           kerror("kdatamanip","lkpad",
                  "Failed to open input object.");
           kexit(KEXIT_FAILURE);
        }

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID) 
	{
           kpds_close_object(in_obj);
           kerror("kdatamanip","lkpad", "Failed to open output object.");
           kexit(KEXIT_FAILURE);
        }

	/* Get Object's dimensions */
	if (kpds_query_value(in_obj))
	{
	   if (!kpds_get_attribute(in_obj,
	      KPDS_VALUE_SIZE, &w_in, &h_in, &d_in, &t_in, &e_in)) 
	   {
              kerror("kpad", "main","Cannot determine input object value size");
	      kexit(KEXIT_FAILURE);
	   }
	}
	else if (kpds_query_mask(in_obj))
	{
	   if (!kpds_get_attribute(in_obj,
	      KPDS_MASK_SIZE, &w_in, &h_in, &d_in, &t_in, &e_in)) 
	   {
              kerror("kpad", "main","Cannot determine input object mask size");
	      kexit(KEXIT_FAILURE);
	   }
	}
	else
	{
           kerror("kpad", "main",
		"Input object must have value and/or mask data");
	   kexit(KEXIT_FAILURE);
	}

	/* If the flag was set for a dimension value, assign to variable
	   being passed into lkpad */
	 if (clui_info->wsize_flag)	w_in = clui_info->wsize_int;
	 if (clui_info->hsize_flag)	h_in = clui_info->hsize_int;
	 if (clui_info->dsize_flag)	d_in = clui_info->dsize_int;
	 if (clui_info->tsize_flag)	t_in = clui_info->tsize_int;
	 if (clui_info->esize_flag)	e_in = clui_info->esize_int;

        if (!kpds_copy_object_attr(in_obj, out_obj))
        {
           kerror("kpad","main",
                  "Cannot copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if ( ! (lkpad(in_obj, w_in, h_in, d_in, t_in, e_in,
		clui_info->woff_int, clui_info->hoff_int,
		clui_info->doff_int, clui_info->toff_int,
		clui_info->eoff_int, clui_info->real_double, 
		clui_info->imag_double, clui_info->valid_logic, out_obj)) ) 
	{
           kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
        if (!kpds_copy_remaining_data(in_obj, out_obj))
        {
           kerror("kpad","main",
                  "Cannot copy remaining data from input to output object.");
           kexit(KEXIT_FAILURE);
        }

	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kpad", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

	kpds_close_object(in_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kpad_usage_additions
| 
|       Purpose: Prints usage additions in kpad_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kpad
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kpad_usage_additions(void)
{
	kfprintf(kstderr, "\tPad Data with a Constant Value\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kpad_free_args
| 
|       Purpose: Frees CLUI struct allocated in kpad_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kpad
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kpad_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
