 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for knormal
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "knormal.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Normalize Data Regions Using Minimum & Maximum of Each Region
|
|       Purpose: main program for knormal
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->lval_double; {Lower normalization value}
|		int    clui_info->lval_flag; {TRUE if -lval specified}
|
|		double clui_info->uval_double; {Upper normalization value}
|		int    clui_info->uval_flag; {TRUE if -uval specified}
|
|		int   clui_info->type_list; {Data type of Output}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|		Optional M.E. group:
|		    int clui_info->whole_flag; {TRUE if -whole specified}
|
|		    Loose group:
|			int clui_info->w_flag; {TRUE if -w specified}
|
|			int clui_info->h_flag; {TRUE if -h specified}
|
|			int clui_info->d_flag; {TRUE if -d specified}
|
|			int clui_info->t_flag; {TRUE if -t specified}
|
|			int clui_info->e_flag; {TRUE if -e specified}
|
|		M.I. group:
|		    double clui_info->dmin_double; {If specified, this value used as data minimum}
|		    int    clui_info->dmin_flag; {TRUE if -dmin specified}
|
|		    double clui_info->dmax_double; {If specified, this value used as data maximum}
|		    int    clui_info->dmax_flag; {TRUE if -dmax specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject src_obj, dst_obj;
	int	apriori = FALSE;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(knormal_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "knormal",
		knormal_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	knormal_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((src_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("knormal","main", "Cannot open input object %s.",
                   clui_info->i_file);
           kexit(KEXIT_FAILURE);
        }
        if ((dst_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
        {
           kerror("knormal","main", "Cannot open output object %s.",
                   clui_info->o_file);
           kexit(KEXIT_FAILURE);
        }
 
        if (!kpds_copy_object_attr(src_obj, dst_obj))
        {
           kerror("knormal", "main",
                  "Unable to copy attributes from input to output.");
           kexit(KEXIT_FAILURE);
        }
	
	if (clui_info->dmin_flag || clui_info->dmax_flag)
	   apriori = TRUE;
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lknormal(src_obj, clui_info->lval_double, clui_info->uval_double,
				apriori, 
				clui_info->dmin_double, clui_info->dmax_double,
                                clui_info->w_flag, clui_info->h_flag,
                                clui_info->d_flag, clui_info->t_flag,
                                clui_info->e_flag, clui_info->whole_flag,
                                clui_info->type_label, dst_obj))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(dst_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("knormal", "main",
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
 
        if (!kpds_copy_remaining_data(src_obj, dst_obj))
        {
           kerror("knormal", "main",
                  "Unable to copy remaining data from source to destination.");
           kexit(KEXIT_FAILURE);
        }
 
        kpds_close_object(src_obj);
        kpds_close_object(dst_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: knormal_usage_additions
| 
|       Purpose: Prints usage additions in knormal_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname knormal
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void knormal_usage_additions(void)
{
	kfprintf(kstderr, "\tNormalize Data Regions Using Minimum & Maximum of Each Region\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: knormal_free_args
| 
|       Purpose: Frees CLUI struct allocated in knormal_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname knormal
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
knormal_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
