 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for knoise
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "knoise.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Introduce Noise in Input Object
|
|       Purpose: main program for knoise
|
|         Input:
|		char *clui_info->i_file; {input file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->replace_flag; {TRUE if -replace specified}
|
|		    int clui_info->add_flag; {TRUE if -add specified}
|
|		Required M.E. group:
|		    M.I. group:
|			int clui_info->gauss_flag; {TRUE if -gauss specified}
|
|			double clui_info->gmean_double; {Mean for Gaussian noise}
|			int    clui_info->gmean_flag; {TRUE if -gmean specified}
|
|			double clui_info->gvar_double; {Variance for Gaussian noise}
|			int    clui_info->gvar_flag; {TRUE if -gvar specified}
|
|		    M.I. group:
|			int clui_info->ray_flag; {TRUE if -ray specified}
|
|			double clui_info->rvar_double; {Variance for Rayleigh noise}
|			int    clui_info->rvar_flag; {TRUE if -rvar specified}
|
|		    M.I. group:
|			int clui_info->unif_flag; {TRUE if -unif specified}
|
|			double clui_info->umax_double; {Maximum value for uniform distribution}
|			int    clui_info->umax_flag; {TRUE if -umax specified}
|
|			double clui_info->umin_double; {Minimum value for uniform noise}
|			int    clui_info->umin_flag; {TRUE if -umin specified}
|
|		    M.I. group:
|			int clui_info->poiss_flag; {TRUE if -poiss specified}
|
|			double clui_info->ptime_double; {Amount of time}
|			int    clui_info->ptime_flag; {TRUE if -ptime specified}
|
|			double clui_info->pvar_double; {Variance for Poisson distribution}
|			int    clui_info->pvar_flag; {TRUE if -pvar specified}
|
|		    M.I. group:
|			int clui_info->exp_flag; {TRUE if -exp specified}
|
|			double clui_info->evar_double; {Variance for exponential distribution}
|			int    clui_info->evar_flag; {TRUE if -evar specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj;
        kobject out_obj;
        char    *function=NULL;
        double  noise_spec1 = 0.0, noise_spec2 = 0.0;
        int     add;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(knoise_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "knoise",
		knoise_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	knoise_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj  = kpds_open_input_object(clui_info->i_file)) == NULL)
        {
           kerror("knoise","main",
                  "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file)) == NULL)
        {
           kerror("knoise","main",
                  "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->gauss_flag)
        {
           function = "gauss";
           noise_spec1 = clui_info->gmean_double;
           noise_spec2 = clui_info->gvar_double;
        }
        else if (clui_info->ray_flag)
        {
           function = "ray";
           noise_spec1 = clui_info->rvar_double;
        }
        else if (clui_info->unif_flag)
        {
           function = "unif";
           noise_spec1 = clui_info->umin_double;
           noise_spec2 = clui_info->umax_double;
           
           if (noise_spec2 <= noise_spec1)
           {
              
              kerror("knoise","main",
                     "Min cannot be greater than max for uniform distribution");
              kexit(KEXIT_FAILURE);
           }
        }
        else if (clui_info->poiss_flag)
        {
           function = "poiss";
           noise_spec1 = clui_info->pvar_double;
           noise_spec2 = clui_info->ptime_double;
        }
        else if (clui_info->exp_flag)
        {
           function = "exp";
           noise_spec1 = clui_info->evar_double;
        }
	else 
	{
           kerror("knoise","main", "Function type not specified.");
           kexit(KEXIT_FAILURE);
	}

        add = (clui_info->add_flag) ? 1 : 0;

        if (!kpds_copy_object_attr(in_obj, out_obj))
	{
           kerror("knoise","main", 
		  "Unable to copy attributes from input object to output.");
           kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lknoise(in_obj, function, add, 
           noise_spec1, noise_spec2, out_obj))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("knoise", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(in_obj, out_obj))
	{
           kerror("knoise","main", 
		  "Unable to copy remaining data from input object to output.");
           kexit(KEXIT_FAILURE);
	}

        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: knoise_usage_additions
| 
|       Purpose: Prints usage additions in knoise_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname knoise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void knoise_usage_additions(void)
{
	kfprintf(kstderr, "\tIntroduce Noise in Input Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: knoise_free_args
| 
|       Purpose: Frees CLUI struct allocated in knoise_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname knoise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
knoise_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
