 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kmsquish
   >>>> 
   >>>>    Written By: Scott Wilson (stolen from K1.5 vmsquish, which was written by  Tom Sauer)
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kmsquish_h_
#define _kmsquish_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kmsquish/uis/kmsquish.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  First Input data object (required infile)
 */
char	*i_file;	/* First Input data object FILENAME */
int	 i_flag;	/* First Input data object FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  map data after squishing map (1) or leave map with only one column (0) (optional logical)
 */
int	 map_logic;	/* map data after squishing map (1) or leave map with only one column (0) LOGIC */
int	 map_flag;  	/* map data after squishing map (1) or leave map with only one column (0) FLAG */

/*
 * squishing scheme (1)average, (2)RMS, (3)Maximum (Optional integer toggle)
 *	1 (Average of map columns)
 *	2 (RMS value of map columns)
 *	3 (Maximum value of mape columns),
 */
int	 t_toggle;		/* squishing scheme (1)average, (2)RMS, (3)Maximum INT TOGGLE */
int	 t_flag;		/* squishing scheme (1)average, (2)RMS, (3)Maximum FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kmsquish_get_args PROTO((kform *));
void kmsquish_usage_additions PROTO((void));
void kmsquish_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
