 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kmapdata
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kmapdata.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Map Value Data Through the Map
|
|       Purpose: main program for kmapdata
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner & Steve Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj;
        kobject out_obj;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kmapdata_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kmapdata",
		kmapdata_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kmapdata_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* 
	 *  Open the input and output data objects.
         */
        if ((in_obj  = kpds_open_input_object(clui_info->i_file)) == NULL)
        {
           kerror("kmapdata","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file)) == NULL)
        {
           kerror("kmapdata","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }


	/* 
         *  Set the KPDS_MAPPING_MODE of the input object to KMAPPED.
         *  This will cause the value data to be mapped through the 
         *  map data.  Copy the attributes and data from the input
         *  object to the output object *after* setting mapping mode
         *  to KMAPPED.  This will ensure that the correct size and 
         *  datatype attributes are transferred.
         */
	if (!kpds_set_attribute(in_obj, KPDS_MAPPING_MODE, KMAPPED))
        {
           kerror("kmapdata", "main", "Unable to set mapping attribute.");
           kexit(KEXIT_FAILURE);
        }

	/*
	 *  Copy the data through the source presentation into the destination.
         */
        if (!kpds_copy_object(in_obj, out_obj))
        {
           kerror("kmapdata", "main", "Unable to copy input object to output.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kmapdata", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kmapdata_usage_additions
| 
|       Purpose: Prints usage additions in kmapdata_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kmapdata
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kmapdata_usage_additions(void)
{
	kfprintf(kstderr, "\tMap Value Data Through the Map\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kmapdata_free_args
| 
|       Purpose: Frees CLUI struct allocated in kmapdata_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kmapdata
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kmapdata_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
