 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "klogexp.h"
/*-----------------------------------------------------------
| 
|  Routine Name: klogexp_get_args
| 
|       Purpose: Gets command line args for klogexp
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klogexp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void klogexp_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for klogexp is out of sync with arguments specified in klogexp's *.pane file; please rerun ghostwriter on klogexp.";


	/*
	 * allocate the klogexp structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "inv",
			  &(clui_info->inv_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "offset",
			  &(clui_info->offset_logic),
			  &(clui_info->offset_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "be",
			  &(clui_info->be_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "b10",
			  &(clui_info->b10_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "b2",
			  &(clui_info->b2_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "base",
			  &(clui_info->base_double),
			  &(clui_info->base_flag))))
	{
	    kerror(NULL, "klogexp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



