 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for klocxform
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "klocxform.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Rotate, Translate, and Scale Location Data
|
|       Purpose: main program for klocxform
|
|         Input:
|		char *clui_info->i_file; {the input object to be processed}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {the output object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		float clui_info->xrot_float; {rotate around x axis}
|		int   clui_info->xrot_flag; {TRUE if -xrot specified}
|
|		float clui_info->yrot_float; {rotate around y axis}
|		int   clui_info->yrot_flag; {TRUE if -yrot specified}
|
|		float clui_info->zrot_float; {rotate around z axis}
|		int   clui_info->zrot_flag; {TRUE if -zrot specified}
|
|		int clui_info->fx_flag; {TRUE if -fx specified}
|
|		float clui_info->xtrans_float; {translate in x direction}
|		int   clui_info->xtrans_flag; {TRUE if -xtrans specified}
|
|		int clui_info->fy_flag; {TRUE if -fy specified}
|
|		float clui_info->ytrans_float; {translate in y direction}
|		int   clui_info->ytrans_flag; {TRUE if -ytrans specified}
|
|		int clui_info->fz_flag; {TRUE if -fz specified}
|
|		float clui_info->ztrans_float; {translate in z direction}
|		int   clui_info->ztrans_flag; {TRUE if -ztrans specified}
|
|		Optional M.E. group:
|		    float clui_info->scale_float; {orthogonal scale factor}
|		    int   clui_info->scale_flag; {TRUE if -scale specified}
|
|		    Loose group:
|			float clui_info->xscale_float; {scale x coordinates}
|			int   clui_info->xscale_flag; {TRUE if -xscale specified}
|
|			float clui_info->yscale_float; {scale y coordinates}
|			int   clui_info->yscale_flag; {TRUE if -yscale specified}
|
|			float clui_info->zscale_float; {scale z coordinates}
|			int   clui_info->zscale_flag; {TRUE if -zscale specified}
|
|        Output:
|       Returns:
|
|    Written By: Steve Kubica
|          Date: Apr 15, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj = NULL;
	kobject out_obj = NULL;

	float xrot;
	float yrot;
	float zrot;
	float xtrans;
	float ytrans;
	float ztrans;
	float xscale;
	float yscale;
	float zscale;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(klocxform_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "klocxform",
		klocxform_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	klocxform_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* -- calculate the needed rotations -- */
	xrot   = (clui_info->xrot_flag) ? clui_info->xrot_float : 0.0;
	yrot   = (clui_info->yrot_flag) ? clui_info->yrot_float : 0.0;
	zrot   = (clui_info->zrot_flag) ? clui_info->zrot_float : 0.0;

	/* -- calculate the needed rotations -- */
	xtrans = (clui_info->xtrans_flag) ? clui_info->xtrans_float : 0.0;
	ytrans = (clui_info->ytrans_flag) ? clui_info->ytrans_float : 0.0;
	ztrans = (clui_info->ztrans_flag) ? clui_info->ztrans_float : 0.0;

	/* -- calculate the needed scalings -- */
	if (clui_info->scale_float)
	{
	   xscale = yscale = zscale = clui_info->scale_float;
	}
	else
	{
	   xscale = (clui_info->xscale_flag) ? clui_info->xscale_float : 1.0;
	   ytrans = (clui_info->yscale_flag) ? clui_info->yscale_float : 1.0;
	   ztrans = (clui_info->zscale_flag) ? clui_info->zscale_float : 1.0;
	}

	/* -- flip scaling where desired -- */
	if (clui_info->fx_flag) xscale *= -1.0;
	if (clui_info->fy_flag) yscale *= -1.0;
	if (clui_info->fz_flag) zscale *= -1.0;


	if ((in_obj = kpds_open_input_object(clui_info->i_file)) == NULL)
	{
           kerror("klocxform","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
	}

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) == NULL)
        {
           kerror("klocxform","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

	/* -- initialize _every_ segment in destination ... -- */
        if (!kpds_copy_object_attr(in_obj, out_obj))
	{
           kerror("klocxform","main", 
		  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }

	/* -- ... except location segment - we do that in library call -- */
	if (kpds_query_location(out_obj))
	   if (!kpds_destroy_location(out_obj))
	   {
	      kerror("klocxform","main", 
		     "Unable to destroy temporary location segment.");
	      kexit(KEXIT_FAILURE);
	   }
/* -main_before_lib_call_end */

/* -main_library_call */
	/* -- create location in destination with transformed locations -- */
	lklocxform(in_obj, 
		   xrot,   yrot,   zrot,
		   xtrans, ytrans, ztrans,
		   xscale, yscale, zscale,
		   out_obj);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* -- add history to the output object -- */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("klocxform", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(in_obj, out_obj))
	{
           kerror("klocxform","main", 
		  "Unable to copy remaining data from input to output "
		  "object.");
           kexit(KEXIT_FAILURE);
        }

	kpds_close_object(in_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: klocxform_usage_additions
| 
|       Purpose: Prints usage additions in klocxform_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klocxform
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void klocxform_usage_additions(void)
{
	kfprintf(kstderr, "\tRotate, Translate, and Scale Location Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: klocxform_free_args
| 
|       Purpose: Frees CLUI struct allocated in klocxform_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klocxform
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
klocxform_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
