 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kinverse
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kinverse.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Inverse Filtering (Restoration) in Fourier Frequency Domain
|
|       Purpose: main program for kinverse
|
|         Input:
|		char *clui_info->i1_file; {source data object (FFT)}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {PSF data object (FFT)}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {filtered data object (FFT)}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->t_double; {filter threshold (magnitude)}
|		int    clui_info->t_flag; {TRUE if -t specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj,psf_obj,out_obj;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kinverse_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kinverse",
		kinverse_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kinverse_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i1_file))
                == KOBJECT_INVALID)
          {
            kerror("kinverse","main", "Cannot open input object.");
            kexit(KEXIT_FAILURE);
          }
        if ((psf_obj = kpds_open_input_object(clui_info->i2_file))
                == KOBJECT_INVALID)
          {
            kerror("kinverse","main", "Cannot open PSF object.");
            kexit(KEXIT_FAILURE);
          }
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
          {
            kerror("kinverse","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
          }
        if (!kpds_copy_object_attr(in_obj, out_obj))
          {
            kerror("kinverse","main",
              "Unable to copy attributes from input to output object.");
            kexit(KEXIT_FAILURE);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lkinverse(in_obj,psf_obj,clui_info->t_double,out_obj))
             kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output objects and write */
        if (!kpds_set_attribute(out_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("kinverse", "main","Unable to set history on output object"
);
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj);
        kpds_close_object(in_obj);
        kpds_close_object(psf_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kinverse_usage_additions
| 
|       Purpose: Prints usage additions in kinverse_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kinverse
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kinverse_usage_additions(void)
{
	kfprintf(kstderr, "\tInverse Filtering (Restoration) in Fourier Frequency Domain\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kinverse_free_args
| 
|       Purpose: Frees CLUI struct allocated in kinverse_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kinverse
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kinverse_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
