 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for khistops
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _khistops_h_
#define _khistops_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/khistops/uis/khistops.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  perform histogram equalization (optional flag)
 */
int	 equalize_flag;  	/* perform histogram equalization FLAG */

/*
 *  perform linear histogram stretch (optional flag)
 */
int	 stretch_flag;  	/* perform linear histogram stretch FLAG */

/*-- required ME group end ---*/

/*----- required ME group ----*/
/*
 *  process whole data set at one time (optional flag)
 */
int	 whole_flag;  	/* process whole data set at one time FLAG */

	/*---- nested optional   group ----*/
/*
 *  include width in processing unit (optional flag)
 */
int	 w_flag;  	/* include width in processing unit FLAG */

/*
 *  include height in processing unit (optional flag)
 */
int	 h_flag;  	/* include height in processing unit FLAG */

/*
 *  include depth in processing unit (optional flag)
 */
int	 d_flag;  	/* include depth in processing unit FLAG */

/*
 *  include time in processing unit (optional flag)
 */
int	 t_flag;  	/* include time in processing unit FLAG */

/*
 *  include elements in processing unit (optional flag)
 */
int	 e_flag;  	/* include elements in processing unit FLAG */

	/*-- nested optional   group end --*/

/*-- required ME group end ---*/

/*
 *  invert grey levels after processing (optional flag)
 */
int	 invert_flag;  	/* invert grey levels after processing FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void khistops_get_args PROTO((kform *));
void khistops_usage_additions PROTO((void));
void khistops_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
