 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for khisto
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _khisto_h_
#define _khisto_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/khisto/uis/khisto.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*
 *  Output data object (required outfile)
 */
char	*o_file;	/* Output data object FILENAME */
int	 o_flag;	/* Output data object FLAG */

/*
 *  Gating input data object (optional infile)
 */
char	*igate_file;	/* Gating input data object FILENAME */
int	 igate_flag;	/* Gating input data object FLAG */

/*
 *  number of histogram bins (optional integer)
 */
int	 bins_int; 	/* number of histogram bins INT */
int	 bins_flag;	/* number of histogram bins FLAG */

/*
 *  width of histogram bin (optional double)
 */
double	 binwidth_double;	/* width of histogram bin DOUBLE */
int	 binwidth_flag;   	/* width of histogram bin FLAG */

/*
 *  Min side of min histogram bin (optional double)
 */
double	 min_double;	/* Min side of min histogram bin DOUBLE */
int	 min_flag;   	/* Min side of min histogram bin FLAG */

/*
 *  append a pair of bins for out-of-bounds data (optional flag)
 */
int	 oob_flag;  	/* append a pair of bins for out-of-bounds data FLAG */

/*----- optional ME group ----*/
/*
 *  histogram whole data set at one time (optional flag)
 */
int	 whole_flag;  	/* histogram whole data set at one time FLAG */

	/*---- nested optional   group ----*/
/*
 *  include width in histogram unit (optional flag)
 */
int	 w_flag;  	/* include width in histogram unit FLAG */

/*
 *  include height in histogram unit (optional flag)
 */
int	 h_flag;  	/* include height in histogram unit FLAG */

/*
 *  include depth in histogram unit (optional flag)
 */
int	 d_flag;  	/* include depth in histogram unit FLAG */

/*
 *  include time in histogram unit (optional flag)
 */
int	 t_flag;  	/* include time in histogram unit FLAG */

/*
 *  include elements in histogram unit (optional flag)
 */
int	 e_flag;  	/* include elements in histogram unit FLAG */

	/*-- nested optional   group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void khisto_get_args PROTO((kform *));
void khisto_usage_additions PROTO((void));
void khisto_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
