 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgenloc.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgenloc_get_args
| 
|       Purpose: Gets command line args for kgenloc
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenloc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenloc_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgenloc is out of sync with arguments specified in kgenloc's *.pane file; please rerun ghostwriter on kgenloc.";

	char  *value_string;


	/*
	 * allocate the kgenloc structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "xbegin",
			  &(clui_info->xbegin_double),
			  &(clui_info->xbegin_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "xend",
			  &(clui_info->xend_double),
			  &(clui_info->xend_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ybegin",
			  &(clui_info->ybegin_double),
			  &(clui_info->ybegin_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "yend",
			  &(clui_info->yend_double),
			  &(clui_info->yend_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "zbegin",
			  &(clui_info->zbegin_double),
			  &(clui_info->zbegin_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "zend",
			  &(clui_info->zend_double),
			  &(clui_info->zend_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "grid", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->grid_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->grid_toggle = atoi(value_string);

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsize",
			  &(clui_info->dsize_int),
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kgenloc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



