 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgate.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgate_get_args
| 
|       Purpose: Gets command line args for kgate
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgate_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgate is out of sync with arguments specified in kgate's *.pane file; please rerun ghostwriter on kgate.";


	/*
	 * allocate the kgate structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kgate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kgate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "igate",
			  &(clui_info->igate_file),
			  &(clui_info->igate_flag))))
	{
	    kerror(NULL, "kgate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "logic",
			  &(clui_info->logic_logic),
			  &(clui_info->logic_flag))))
	{
	    kerror(NULL, "kgate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "gval",
			  &(clui_info->gval_double),
			  &(clui_info->gval_flag))))
	{
	    kerror(NULL, "kgate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kgate_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



