 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgate
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgate.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Output Assigned Value in Input 1 or Input 2 Based on Gating Element
|
|       Purpose: main program for kgate
|
|         Input:
|		char *clui_info->i1_file; {First input data object}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {Second input file object}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->igate_file; {Gating input data object}
|		int   clui_info->igate_flag; {TRUE if -igate specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->logic_logic; {Gating logic: if gate data = gval, (0) use i1, (1) use i2}
|		int clui_info->logic_flag; {TRUE if -logic specified}
|
|		double clui_info->gval_double; {Value on which to gate}
|		int    clui_info->gval_flag; {TRUE if -gval specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner & Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj1=NULL, in_obj2=NULL;
        kobject gate_obj=NULL, out_obj=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kgate_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kgate",
		kgate_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgate_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj1 = kpds_open_input_object(clui_info->i1_file)) 
		== KOBJECT_INVALID)
        {
           kerror("kgate","main","Cannot open input object 1.");
           kexit(KEXIT_FAILURE);
        }

        if ((in_obj2 = kpds_open_input_object(clui_info->i2_file)) 
		== KOBJECT_INVALID)
        {
           kerror("kgate","main","Cannot open input object 2.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
        {
           kerror("kgate","main","Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

	if (!kpds_copy_object_attr(in_obj1, out_obj))
        {
           kerror("kgate","main",
		  "Cannot copy attributes from input1 to output.");
           kexit(KEXIT_FAILURE);
        }

        if ((gate_obj = kpds_open_input_object(clui_info->igate_file))
		== KOBJECT_INVALID)
        {
           kerror("kgate","main","Cannot open gating object.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lkgate(in_obj1, in_obj2, gate_obj, clui_info->gval_double,
		    clui_info->logic_logic, out_obj))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kgate", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

	if (!kpds_copy_remaining_data(in_obj1, out_obj))
        {
           kerror("kgate","main",
		  "Cannot copy remaining data from input1 to output.");
           kexit(KEXIT_FAILURE);
        }

	kpds_close_object(in_obj1);
	kpds_close_object(in_obj2);
	kpds_close_object(gate_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgate_usage_additions
| 
|       Purpose: Prints usage additions in kgate_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgate_usage_additions(void)
{
	kfprintf(kstderr, "\tOutput Assigned Value in Input 1 or Input 2 Based on Gating\n");
	kfprintf(kstderr, "\tElement\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgate_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgate_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgate_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->igate_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
