 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kflip
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kflip.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Reflect Data Along Specified Directions
|
|       Purpose: main program for kflip
|
|         Input:
|		char *clui_info->i_file; {Source (input) object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Destination (output) object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Loose group:
|		    int clui_info->w_flag; {TRUE if -w specified}
|
|		    int clui_info->h_flag; {TRUE if -h specified}
|
|		    int clui_info->d_flag; {TRUE if -d specified}
|
|		    int clui_info->t_flag; {TRUE if -t specified}
|
|		    int clui_info->e_flag; {TRUE if -e specified}
|
|        Output:
|       Returns:
|
|    Written By: Ramiro Jordan
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject src = NULL;    /* source object */
        int num_dim = 0;       /* counter to indicate No. of dimensions */ 
        int index = 0;
        long *dim_list;
        char *prog = "main";   /* main/library name (for error reporting) */
        char *rtn = "kflip";   /* routine name (for error reporting) */
        kobject dest = NULL;   /* destination object */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kflip_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kflip",
		kflip_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kflip_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
       /*
        * Open the source and destination data objects using the
        * kpds_open_input_object and kpds_open_output_object calls.
        * These calls will open the source and destination data
        * objects with the flags set correctly.  If an open
        * fails, report the error using kerror, close opened objects if
        * necessary, and exit the program using the kexit call.
        */
 
        if ((src=kpds_open_input_object(clui_info->i_file)) == KOBJECT_INVALID)
        {
            kerror( rtn, prog, "Cannot open source object.");
            kexit(KEXIT_FAILURE);
        }
 
        if ((dest=kpds_open_output_object(clui_info->o_file))==KOBJECT_INVALID)
        {
            kerror( rtn, prog, "Cannot open destination object.");
            kpds_close_object(src);
            kexit(KEXIT_FAILURE);
        }

       /*
        * The lkflip library should have no side effects on the
        * destination object.  It will only manipulate the value data,
        * the mask, if it exists, and the attributes of the destination
        * data object that are related to the reflection operation.
        *
        * Since the source object may contain additional attributes
        * that may or may not be part of the data model,
        * the source object needs to be copied to the destination object
        * so that the user is not surprised by unwanted side effects.
        * Example: removal of map or location data.
        *
        * Use the kpds_copy_object function to copy attributes and data
        * between source and destination objects.
        *
        * If the copy function fails, report the error, close the source
        * and destination objects, and exit.
        */
 
        if (!kpds_copy_object(src, dest))
        {
            kerror( rtn, prog, "kpds_copy_object_attr failed.");
            kexit(KEXIT_FAILURE);
        }

       /*
        * Assign variables.  The clui_info structure is created by
        * the code generators using the user interface specification file
        * (kflip.pane), and this structure is located in the kflip.h
        * file.
        *
        * The reflection directions are determined:
        * 
        *    if "flag" is true then increment No. of dimensions. 
        *
        */
 
        if (clui_info->w_flag) num_dim++;
        if (clui_info->h_flag) num_dim++;
        if (clui_info->d_flag) num_dim++;
        if (clui_info->t_flag) num_dim++;
        if (clui_info->e_flag) num_dim++;

       /* Allocate memory in dim_list according to the number
        * of dimensions selected. Check each flag to see if
        * it has been set. If set store the dimension in
        * dim_list. index is initialized to 0.
        */

        index = 0;
        dim_list = (long *) kmalloc(num_dim*sizeof(long));

        if (clui_info->w_flag) dim_list[index++] = KWIDTH;
        if (clui_info->h_flag) dim_list[index++] = KHEIGHT;
        if (clui_info->d_flag) dim_list[index++] = KDEPTH;
        if (clui_info->t_flag) dim_list[index++] = KTIME;
        if (clui_info->e_flag) dim_list[index++] = KELEMENTS;
/* -main_before_lib_call_end */

/* -main_library_call */
        /*
         * Once all of the preliminary work has been done, pass the source,
         * and destination objects.  Also, pass parameters to indicate
         * the directions for reflecting the data elements. 
         * After execution of lkflip close the objects and exit the
         * kflip routine.
         */

        if (!lkflip ( src, num_dim, dim_list, dest ))
        {
            kpds_close_object(src);
            kpds_close_object(dest);
            kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(dest, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kflip", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

       /*
        * If the library call succeeded, close the source and
        * destination data objects using kpds_close_object and exit
        * using kexit.
        */
        kpds_close_object(src);
        kpds_close_object(dest);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kflip_usage_additions
| 
|       Purpose: Prints usage additions in kflip_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kflip
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kflip_usage_additions(void)
{
	kfprintf(kstderr, "\tReflect Data Along Specified Directions\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kflip_free_args
| 
|       Purpose: Frees CLUI struct allocated in kflip_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kflip
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kflip_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
