 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kconvert
   >>>> 
   >>>>    Written By: John M. Salas & Donna Koechner
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kconvert_h_
#define _kconvert_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "ksegops/ksegops.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kconvert/uis/kconvert.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input data object (required infile)
 */
char	*i_file;	/* input data object FILENAME */
int	 i_flag;	/* input data object FLAG */

/*
 *  resulting data object (required outfile)
 */
char	*o_file;	/* resulting data object FILENAME */
int	 o_flag;	/* resulting data object FLAG */

/*----- required ME group ----*/
/*
 *  If -val flag is selected, operate on Value segment (optional flag)
 */
int	 val_flag;  	/* If -val flag is selected, operate on Value segment FLAG */

/*
 *  If -map flag is selected, operate on Map segment (optional flag)
 */
int	 map_flag;  	/* If -map flag is selected, operate on Map segment FLAG */

/*
 *  If -mask flag is selected, operate on Mask segment (optional flag)
 */
int	 mask_flag;  	/* If -mask flag is selected, operate on Mask segment FLAG */

/*
 *  If -loc flag is selected, operate on Location segment (optional flag)
 */
int	 loc_flag;  	/* If -loc flag is selected, operate on Location segment FLAG */

/*
 *  If -time flag is selected, operate on Time segment (optional flag)
 */
int	 time_flag;  	/* If -time flag is selected, operate on Time segment FLAG */

/*
 *  Perform operation on user specified segment (optional string)
 */
char	*segment_string;	/* Perform operation on user specified segment STRING */
int	 segment_flag;   	/* Perform operation on user specified segment FLAG */

/*-- required ME group end ---*/

/*
 *  Convert to specified data type (Optional list)
 */
int	 type_list;	/* Convert to specified data type LIST INDEX */
char	 *type_label;	/* Convert to specified data type LIST LABEL */
int	 type_flag;	/* Convert to specified data type FLAG */

/*
 *  Real scale factor (optional double)
 */
double	 scale_double;	/* Real scale factor DOUBLE */
int	 scale_flag;   	/* Real scale factor FLAG */

/*
 *  Real offset value (optional double)
 */
double	 roff_double;	/* Real offset value DOUBLE */
int	 roff_flag;   	/* Real offset value FLAG */

/*
 *  Imaginary offset value (optional double)
 */
double	 ioff_double;	/* Imaginary offset value DOUBLE */
int	 ioff_flag;   	/* Imaginary offset value FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kconvert_get_args PROTO((kform *));
void kconvert_usage_additions PROTO((void));
void kconvert_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
