 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kclip
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kclip.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Clip or Threshold the Range of Values in Object
|
|       Purpose: main program for kclip
|
|         Input:
|		char *clui_info->i_file; {Input file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Loose group:
|		    Optional M.E. group:
|			double clui_info->lc_double; {Constant lower cutoff value}
|			int    clui_info->lc_flag; {TRUE if -lc specified}
|
|			char *clui_info->ilc_file; {File containing lower cutoff values}
|			int   clui_info->ilc_flag; {TRUE if -ilc specified}
|
|		    Optional M.E. group:
|			double clui_info->uc_double; {Constant upper cutoff value}
|			int    clui_info->uc_flag; {TRUE if -uc specified}
|
|			char *clui_info->iuc_file; {File containing upper cutoff values}
|			int   clui_info->iuc_flag; {TRUE if -iuc specified}
|
|		int clui_info->thresh_logic; {Clip (0) or Threshold (1) Object Data}
|		int clui_info->thresh_flag; {TRUE if -thresh specified}
|
|		double clui_info->fval_double; {Value assigned to output if evaluation is FALSE}
|		int    clui_info->fval_flag; {TRUE if -fval specified}
|
|		double clui_info->tval_double; {Value assigned to output if evaluation is TRUE (thresholding only)}
|		int    clui_info->tval_flag; {TRUE if -tval specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner, Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj = NULL;
        kobject uc_obj = NULL;
        kobject lc_obj = NULL;
        kobject out_obj = NULL;
	int     uv_flag=0, lv_flag=0;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kclip_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kclip",
		kclip_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kclip_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
        {
           kerror("kclip","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
        {
           kerror("kclip","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->iuc_flag)
        {
           if ((uc_obj = kpds_open_input_object(clui_info->iuc_file)) 
		== KOBJECT_INVALID)
           {
              kerror("kclip","main", "Cannot open upper cutoff value object.");
              kexit(KEXIT_FAILURE);
           }
        }

        if (clui_info->ilc_flag)
        {
           if ((lc_obj = kpds_open_input_object(clui_info->ilc_file)) 
		== KOBJECT_INVALID)
           {
              kerror("kclip","main", "Cannot open lower cutoff value object.");
              kexit(KEXIT_FAILURE);
           }
        }

        if (!kpds_copy_object_attr(in_obj,out_obj))
	{
           kerror("kclip","main", 
		  "Unable to copy input object attributes to output.");
           kexit(KEXIT_FAILURE);
	}

	if (clui_info->ilc_flag || clui_info->lc_flag)
	   lv_flag = TRUE;
	if (clui_info->iuc_flag || clui_info->uc_flag)
	   uv_flag = TRUE;

	if ( (!uv_flag) && (!lv_flag) )
	{
           kerror("kclip","main", 
	   "Select at least one upper or lower cutoff value option.");
           kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lkclip(in_obj, lc_obj, uc_obj, 
		    clui_info->lc_double, clui_info->uc_double,
                    clui_info->fval_double, clui_info->tval_double, 
                    lv_flag, uv_flag, 
                    clui_info->fval_flag, clui_info->tval_flag, 
		    clui_info->thresh_logic, out_obj))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kclip", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(in_obj,out_obj))
	{
           kerror("kclip","main", 
		  "Unable to copy remaining data from input object to output.");
           kexit(KEXIT_FAILURE);
	}

        kpds_close_object(out_obj);
        kpds_close_object(in_obj);
        if (clui_info->iuc_flag)  kpds_close_object(uc_obj);
        if (clui_info->ilc_flag)  kpds_close_object(lc_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kclip_usage_additions
| 
|       Purpose: Prints usage additions in kclip_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kclip
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kclip_usage_additions(void)
{
	kfprintf(kstderr, "\tClip or Threshold the Range of Values in Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kclip_free_args
| 
|       Purpose: Frees CLUI struct allocated in kclip_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kclip
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kclip_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
