 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kbitwise.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kbitwise_get_args
| 
|       Purpose: Gets command line args for kbitwise
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kbitwise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kbitwise_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kbitwise is out of sync with arguments specified in kbitwise's *.pane file; please rerun ghostwriter on kbitwise.";


	/*
	 * allocate the kbitwise structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "real",
			  &(clui_info->real_int),
			  &(clui_info->real_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "and",
			  &(clui_info->and_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ls",
			  &(clui_info->ls_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "or",
			  &(clui_info->or_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "rs",
			  &(clui_info->rs_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "xor",
			  &(clui_info->xor_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "srs",
			  &(clui_info->srs_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "nand",
			  &(clui_info->nand_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "rr",
			  &(clui_info->rr_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "nor",
			  &(clui_info->nor_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "lr",
			  &(clui_info->lr_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "andrev",
			  &(clui_info->andrev_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "andinv",
			  &(clui_info->andinv_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "orrev",
			  &(clui_info->orrev_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "orinv",
			  &(clui_info->orinv_flag))))
	{
	    kerror(NULL, "kbitwise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



