 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kbessel.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kbessel_get_args
| 
|       Purpose: Gets command line args for kbessel
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kbessel
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kbessel_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kbessel is out of sync with arguments specified in kbessel's *.pane file; please rerun ghostwriter on kbessel.";


	/*
	 * allocate the kbessel structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kbessel_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kbessel_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "j",
			  &(clui_info->j_flag))))
	{
	    kerror(NULL, "kbessel_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "y",
			  &(clui_info->y_flag))))
	{
	    kerror(NULL, "kbessel_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ord0",
			  &(clui_info->ord0_flag))))
	{
	    kerror(NULL, "kbessel_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ord1",
			  &(clui_info->ord1_flag))))
	{
	    kerror(NULL, "kbessel_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "order",
			  &(clui_info->order_int),
			  &(clui_info->order_flag))))
	{
	    kerror(NULL, "kbessel_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



