 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kasc2mask.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kasc2mask_get_args
| 
|       Purpose: Gets command line args for kasc2mask
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kasc2mask
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kasc2mask_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kasc2mask is out of sync with arguments specified in kasc2mask's *.pane file; please rerun ghostwriter on kasc2mask.";


	/*
	 * allocate the kasc2mask structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "so",
			  &(clui_info->so_int),
			  &(clui_info->so_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "sf",
			  &(clui_info->sf_int),
			  &(clui_info->sf_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "windex", KVF_LIST_LABEL,
			  &(clui_info->windex_label),
			  &(clui_info->windex_flag)) &&
	      kclui_get_value(pane, "windex", KVF_LIST_VAL,
			  &(clui_info->windex_list),
			  &(clui_info->windex_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "hindex", KVF_LIST_LABEL,
			  &(clui_info->hindex_label),
			  &(clui_info->hindex_flag)) &&
	      kclui_get_value(pane, "hindex", KVF_LIST_VAL,
			  &(clui_info->hindex_list),
			  &(clui_info->hindex_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsize",
			  &(clui_info->dsize_int),
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "dindex", KVF_LIST_LABEL,
			  &(clui_info->dindex_label),
			  &(clui_info->dindex_flag)) &&
	      kclui_get_value(pane, "dindex", KVF_LIST_VAL,
			  &(clui_info->dindex_list),
			  &(clui_info->dindex_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsize",
			  &(clui_info->tsize_int),
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "tindex", KVF_LIST_LABEL,
			  &(clui_info->tindex_label),
			  &(clui_info->tindex_flag)) &&
	      kclui_get_value(pane, "tindex", KVF_LIST_VAL,
			  &(clui_info->tindex_list),
			  &(clui_info->tindex_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "esize",
			  &(clui_info->esize_int),
			  &(clui_info->esize_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "eindex", KVF_LIST_LABEL,
			  &(clui_info->eindex_label),
			  &(clui_info->eindex_flag)) &&
	      kclui_get_value(pane, "eindex", KVF_LIST_VAL,
			  &(clui_info->eindex_list),
			  &(clui_info->eindex_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kasc2mask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



