 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Statistics for datamanip
   >>>>
   >>>>    Written By: Ashish Malhotra
   >>>>
   >>>>          Date: Jul 01, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatamanip_lkstats_h_
#define _kdatamanip_lkstats_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/* ----------------------------------------------------------- */
/*   Flags for defining which statistics are calculated        */
/* ----------------------------------------------------------- */

/* Changed order and shifting on several of these defines 3-23-94, DK */
#define KSTATS_MEAN	(1 << 0L)
#define KSTATS_VAR      (1 << 1L)  /* variance */
#define KSTATS_STDDEV	(1 << 2L)  /* standard deviation */
#define KSTATS_RMS      (1 << 3L)
#define KSTATS_SKEW     (1 << 4L)
#define KSTATS_KURT     (1 << 5L)  /* kurtosis */
#define KSTATS_MIN      (1 << 6L)  /* minimum value */
#define KSTATS_MAX      (1 << 7L) /* maximum value */
#define KSTATS_SUM      (1 << 8L) /* Changed from KSTATS_INTEG 3-23-94, DK */
#define KSTATS_POSSUM   (1 << 9L) /* Changed from KSTATS_POSINT 3-23-94, DK */
#define KSTATS_NEGSUM   (1 << 10L) /* Changed from KSTATS_NEGINT 3-23-94, DK */
#define KSTATS_PTS      (1 << 11L) /* number of contributing points */
#define KSTATS_POSPTS   (1 << 12L) /* number of positive contributing points */
#define KSTATS_NEGPTS   (1 << 13L) /* number of negative contributing points */
#define KSTATS_ZEROPTS	(1 << 14L) /* number of zero-valued points */
#define KSTATS_ALL_STATS (1 << 15L) 

/* ----------------------------------------------------------- */
/*   Flags to define auxiliary information to be recorded      */
/* ----------------------------------------------------------- */

/* coordinates of minimum value - moved from statistics flag 3-23-94 DK */
#define KSTATS_WMIN     (1 << 0L)
#define KSTATS_HMIN     (1 << 1L)
#define KSTATS_DMIN     (1 << 2L)
#define KSTATS_TMIN     (1 << 3L)
#define KSTATS_EMIN     (1 << 4L)

/* coordinates of maximum value - moved from statistics flag 3-23-94 DK */
#define KSTATS_WMAX     (1 << 5L)
#define KSTATS_HMAX     (1 << 6L)
#define KSTATS_DMAX     (1 << 7L)
#define KSTATS_TMAX     (1 << 8L)
#define KSTATS_EMAX     (1 << 9L)

/* object dimension sizes - Added 3-23-94 DK */
#define KSTATS_WSIZE    (1 << 10L)  /* size of width dimension */
#define KSTATS_HSIZE    (1 << 11L)  /* size of height dimension */
#define KSTATS_DSIZE    (1 << 12L)  /* size of depth dimension */
#define KSTATS_TSIZE    (1 << 13L)  /* size of time dimension */
#define KSTATS_ESIZE    (1 << 14L)  /* size of elements dimension */

#define KSTATS_ALL_AUXINFO (1 << 15L)


#define KSTATS_MAXPOS   (KSTATS_WMAX | KSTATS_HMAX | KSTATS_DMAX | KSTATS_TMAX |KSTATS_EMAX)
#define KSTATS_MINPOS   (KSTATS_WMIN | KSTATS_HMIN | KSTATS_DMIN | KSTATS_TMIN |KSTATS_EMIN)

/* ----------------------------------------------------------- */
/*   Flags to define region dimensionality for stats analysis  */
/* ----------------------------------------------------------- */
#define KSTATS_WIDTH    (1 << 0L)
#define KSTATS_HEIGHT   (1 << 1L)
#define KSTATS_DEPTH    (1 << 2L)
#define KSTATS_TIME     (1 << 3L)
#define KSTATS_ELEMENT  (1 << 4L)

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _kdatamanip_lkstats_h_ */
/* Don't add after this point */
