#include "bootstrap.h"
 
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kfile *file;
	char  **words, *path;
	int   i, j, num, status;


	if (argc > 1)
	   path = argv[1];

	if ((file = kfopen(path, "r")) == NULL)
	{
	   kprintf("Unable to open file '%s'", path);
	   kexit(KEXIT_FAILURE);
	}

	if ((words = kparse_file_scan_delimit(file, KPARSE_BOF, KPARSE_EOF,
                        KLITERAL, " \t\n", NULL, NULL, &num, &status)) == NULL)
        {
           kprintf("Cannot read contents of file '%s'\n", path);
           kexit(KEXIT_FAILURE);
        }

	words = karray_sort(words, num, TRUE);
	for (i = 1; i < num; i++)
	{
	   if (kstrcmp(words[i-1], words[i]) > 0)
	   {
	      kprintf("'%s' is suppose to be lexically less than '%s'\n",
				words[i-1], words[i]);
	      kexit(KEXIT_FAILURE);
	   }
	}
	karray_free(words, num, NULL);
	kexit(KEXIT_SUCCESS);
}
