eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: kgenindex - no short description specified
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while (<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            warn "The SUPPORT toolbox is defined twice.  Please check your\n";
            warn "KHOROS_TOOLBOX environment variable and the file(s)\n";
            warn "pointed to by it and make sure that all toolboxes are\n";
            die  "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}


@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis = 'no short description specified';
@clui_args  = (
   '[verbose]',  '',  'display verbose information as program runs'
);

# initialize Khoros perl lib
&khoros'initialize("BOOTSTRAP",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

opendir(MANDIR, "./..") || die "Can't read parent directory: $!\n";
@directories = grep(/^[^.]/, readdir(MANDIR));
closedir(MANDIR);

foreach $dir (sort @directories)
{
   next unless -d "../$dir" && -f "../$dir/index.raw";

   open(RAWFILE, "< ../$dir/index.raw") || do
   {
      warn "kgenindex: Could not read index.raw for chapter $dir: $!\n";
      next;
   };

   (print "kgenindex:"),$ok=1 unless $ok;
   print " $dir";
   while (<RAWFILE>)
   {
      chop;
      s/\\f[BHIRP]//g;
      s/\\f\(CW//g;
      s/\\f\(BI//g;
      s/\\s[+-][0-9]//g;

      ($chapter, $page, $word, $category, $definitive) = split(/:/);
      next if $word eq 'N/A';
      $reference = "$chapter-$page";
      $reference = "\\fB$reference\\fP" if $definitive eq 'BOLD';
      if ($category =~ /^\s*$/)
      {
         $index{$word} .= (defined $index{$word}
			   ? ", $reference"
			   : "$reference");
      }
      else
      {
         if (defined $index{"$category\t$word"})
         {
            $index{"$category\t$word"} .= ", $reference";
         }
         else
         {
            $index{"$category\t$word"} .= "$reference";
         }
      }
   }
}
close RAWFILE;
print "\n" if $ok;

open(ROFF, "> index.roff") || die "Can't write index.roff: $!\n";
foreach $word (sort keys %index)
{
   $section = substr($word, 0, 1);
   $section = "\U$section";
   if ($section ne $cursect)
   {
      print ROFF ".LB \"$section\"\n";
      $cursect = $section;
   }
   if ($word =~ /\t/)
   {
      ($category, $minor) = split(/\t/, $word);

      # have we printed out the major index entry, if we need to?
      if (!defined $index{$category} && !$printedCategory{$category})
      {
	 print ROFF ".Ib \"$category\"\n";
	 $printedCategory{$category} = 1;
      }

      print ROFF ".I< \"$category\" \"$minor\" \"", $index{$word},"\"\n";
   }
   else
   {
      print ROFF ".I> \"$word\" \"", $index{$word},"\"\n";
   }
}
close(ROFF);

# the following line was obviously doing something, dunno what yet ...
# sed -e "s/\([0-9A-Z][0-9]*:[0-9A-Z][0-9]*:\)\(.*\)::/\1:\2:/" index.raw
