/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  This include file contains the header
   >>>>			and define information required by the
   >>>>			internal routines in kutils
   >>>>
   >>>>    Written By:  Mark Young
   >>>>
   >>>>          Date: Jul 14, 1992 10:32
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_internals_h_
#define _kutils_internals_h_

        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/

#include <bootstrap.h>
#include <kutils/kfileP.h>

        /*-------------------------------------*
        |       #defines 
        ---------------------------------------*/


#ifndef W_OK
#  define W_OK 2
#endif

#define  TEMPLATE  "xvtemp"
#define  KMAXENTRIES 25

#define MAX_ARGS 200

/*
 *  Defines for convert routines
 */
#define KNUMARCH 4

/*
 *  Default Page Size
 */
#if defined(SYSV) || defined(SVR4)
#define DefaultPageSize	4096
#else
#define DefaultPageSize	getpagesize()
#endif


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/

#ifndef flock
#define flock(fids, function) fcntl(fids, F_SETFD, function)
#endif

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* kroutines.c */
kfile *kfile_checkid PROTO((int));
kfile *kfile_checkfile PROTO((kfile *));
int kfile_add PROTO((kfile *));
int kfile_delete PROTO((kfile *));
int kfile_free PROTO((kfile *));
int kfile_read PROTO((kfile *, char *, int));
int kfile_write PROTO((kfile *, char *, int));
int kfile_close PROTO((kfile *));
kfile *kfile_open PROTO((char *, int, int));
int kfile_rename PROTO((kfile *, char *));
int kfile_seek PROTO((kfile *, int, int));
int kfile_tell PROTO((kfile *));
int kfile_dup PROTO((int, int));
char *ktransport_identifier PROTO((char *, char *));
char *ktransport_token PROTO((char *, char *));
char *ktransport_location PROTO((char *, char *));
char *ktransport_machines PROTO((char *, char *));
TransportInformation *ktransport_routines PROTO((char *));
void build_command PROTO((char **, char *));

/* kconvert.c */
unsigned char *convert_float PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_double PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_complex PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_dcomplex PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_short PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_ushort PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_int PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_uint PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_long PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_ulong PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_byte PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));
unsigned char *convert_ubyte PROTO((unsigned char *, unsigned char *, unsigned int, unsigned int, unsigned int));

/* fildes.c */
int ksend_fildes PROTO((kfile *, kfile *, char *, int));
int krecv_fildes PROTO((kfile *, kfile *, char *, int *));

/* utilities.c */
int _kalias_initialize PROTO((void));
char *_kalias_replace PROTO((char *));
char *_cleanup_string PROTO((char *));
char *_expand_variable PROTO((char *, char *));
char *_expand_tilda PROTO((char *));
char *ktmpnam PROTO((char *));

/* gnuscan.c */
int kdoscan PROTO((kfile *, char *, char *, kva_list));

/* errors.c */
void kutils_init_errors();

#endif /* _kutils_internals_h_ */
/* don't add after the endif */
