/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for ktestutils
   >>>> 
   >>>>	Private: 
   >>>>	Static: 
   >>>>	Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

static int      ktestFailures        = 0;
static int      ktestTestNumber      = 0;
static kstring  ktestTestDescription = NULL;
static kstring  ktestTestsuiteID     = NULL;


/****************************************************************
* Routine Name: ktest_begin - start a testsuite
* 
* Purpose:	This function is used to introduce a testsuite.
*
*		For example, the \fBkcms\fP testsuite for the function
*		\f(CW\s-2kcms_legal_identifier()\s+2\fP starts with the line:
*		.RS
*		\f(CW\s-2
*		ktest_begin("35.kcms", "kcms_legal_identifier()");
*		\s+2\fP
*		.RE
*
* Input:	testsuite_id - The identifier for the testsuite.
*			       This is typically the name of the
*			       directory which contains the testsuite,
*			       but it doesn't have to be.
*		testing      - A short text string (60 characters at most)
*			       which describes what the testsuite is testing.
*
* Written By:	Neil Bowers
* Date:		30-jan-1995
****************************************************************/
void
ktest_begin(
   kstring   testsuite_id,
   kstring   testing)
{
   if (testsuite_id == NULL)
      ktest_error("ktest_begin", "first parameter `testsuite_id' is NULL.");

   if (testing == NULL)
      ktest_error("ktest_begin", "second parameter `testing' is NULL.");

   kprintf("\n--------------------------------------------"
	   "---------------------------------\n");
   kprintf("Testsuite %s - testing %s\n", testsuite_id, testing);
   kprintf("--------------------------------------------"
	   "---------------------------------\n");

   ktestFailures        = 0;
   ktestTestNumber      = 0;
   ktestTestsuiteID     = testsuite_id;
   ktestTestDescription = NULL;
}

/****************************************************************
* Routine Name: ktest_end - end a testsuite
* 
* Purpose:	This function is used to finish a testsuite.
*		This marks the end of the testsuite log, and if
*		any cases failed, then a line is printed to stdout
*		giving the number of failures.
*
*		After printing out any information,
*		ktest_end calls
*		.symbol - kexit()
*		with the parameter KEXIT_SUCCESS if no cases failed,
*		and KEXIT_FAILURE if one or more cases failed.
*
* Written By:	Neil Bowers
* Date:		30-jan-1995
****************************************************************/
void
ktest_end(
   void)
{
   if (ktestTestsuiteID == NULL)
      ktest_error("ktest_end", "you haven't called ktest_begin() first!");

   if (ktestTestDescription != NULL)
      ktest_error("ktest_end",
		  "ktest_case() called, but no call to ktest_result()");

   kprintf("--------------------------------------------"
	   "---------------------------------\n");
   if (ktestFailures > 0)
      kprintf("Number of failures: %d\n", ktestFailures);

   kexit((ktestFailures > 0) ? KEXIT_FAILURE : KEXIT_SUCCESS);
}

/****************************************************************
* Routine Name: ktest_case - introduce a test case
* 
* Purpose:	This function is used to introduce a test case within
*		a testsuite.
*		You should have called ktest_begin() before calling
*		this function.
*
*		For example, when testing the function
*		\f(CW\s-2kcms_add_toolbox()\s+2\fP,
*		one case to test for is a \f(CWNULL\fP toolbox name.
*		This test case is introduced with the following line:
*		.RS
*		\f(CW\s-2
*		ktest_case("NULL toolbox name");
*		\s+2\fP
*		.RE
*
* Input:	description - A short description of the test case.
*			      The description should not exceed 60
*			      characters.
*
* Written By:	Neil Bowers
* Date:		30-jan-1995
****************************************************************/
void
ktest_case(
   kstring  description)
{
   if (ktestTestsuiteID == NULL)
      ktest_error("ktest_case", "you haven't called ktest_begin() first!");

   if (ktestTestDescription != NULL)
      ktest_error("ktest_case",
		  "you haven't called ktest_result() for previous case.");

   ktestTestDescription = description;
   ++ktestTestNumber;
}

/****************************************************************
* Routine Name: ktest_result - end test case and register the result
* 
* Purpose:	This function is used to mark the end of a test case,
*		and register whether the test case passed or failed.
*
*		You should have called ktest_case() before calling
*		this function to introduce the test case.
*
* Input:	result - The result of the test case.
*			 There are two legal values: KTEST_PASS
*			 if the test was successful, KTEST_FAIL otherwise.
*
* Written By:	Neil Bowers
* Date:		30-jan-1995
****************************************************************/
void
ktest_result(
   int  result)
{
   if (ktestTestDescription == NULL)
      ktest_error("ktest_result", "you haven't called ktest_case() first!");

   kprintf("  case %.2d - %-60s %4s\n", ktestTestNumber, ktestTestDescription,
	   (result == KTEST_PASS ? "PASS" : "FAIL"));
   if (result == KTEST_FAIL)
      ktestFailures++;

   ktestTestDescription = NULL;
}
