/*
 * cfft.c: This code is based on an IEEE multiradix fft implementation
 *         that was originally written in fortran.  It was converted
 *         to C using f2c and then further massaged into a form that
 *	   didn't require f2c libraries.
 *
 *  *** THIS CODE IS NOT CONSUMABLE BY HUMANS OR ANY OTHER PRIMATE ***
 */

/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>              Internal FFT Routines
   >>>>
   >>>>   Static:
   >>>>
   >>>>  Private:
   >>>>			fast_
   >>>>			fsst_
   >>>>			fr2tr_
   >>>>			fr4tr_
   >>>>			fr4syn_
   >>>>			ford1_
   >>>>			ford2_
   >>>>			fft842_
   >>>>			r2tx_
   >>>>			r4tx_
   >>>>			r8tx_
   >>>>			pow_ii
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <klibm/kcfft.h>


/* f2c.h  --  Standard Fortran to C header file */

/**  barf  [ba:rf]  2.  "He suggested using FORTRAN, and everybody barfed."

	- From The Shogakukan DICTIONARY OF NEW ENGLISH (Second edition) */

#ifndef F2C_INCLUDE
#define F2C_INCLUDE

#define TRUE_ (1)
#define FALSE_ (0)

/* Extern is for use with -E */
#ifndef Extern
#define Extern extern
#endif

/* I/O stuff */

#ifdef f2c_i2
/* for -i2 */
typedef short flag;
typedef short ftnlen;
typedef short ftnint;
#else
typedef long flag;
typedef long ftnlen;
typedef long ftnint;
#endif

/*external read, write*/
typedef struct
{	flag cierr;
	ftnint ciunit;
	flag ciend;
	char *cifmt;
	ftnint cirec;
} cilist;

/*internal read, write*/
typedef struct
{	flag icierr;
	char *iciunit;
	flag iciend;
	char *icifmt;
	ftnint icirlen;
	ftnint icirnum;
} icilist;

/*open*/
typedef struct
{	flag oerr;
	ftnint ounit;
	char *ofnm;
	ftnlen ofnmlen;
	char *osta;
	char *oacc;
	char *ofm;
	ftnint orl;
	char *oblnk;
} olist;

/*close*/
typedef struct
{	flag cerr;
	ftnint cunit;
	char *csta;
} cllist;

/*rewind, backspace, endfile*/
typedef struct
{	flag aerr;
	ftnint aunit;
} alist;

/* inquire */
typedef struct
{	flag inerr;
	ftnint inunit;
	char *infile;
	ftnlen infilen;
	ftnint	*inex;	/*parameters in standard's order*/
	ftnint	*inopen;
	ftnint	*innum;
	ftnint	*innamed;
	char	*inname;
	ftnlen	innamlen;
	char	*inacc;
	ftnlen	inacclen;
	char	*inseq;
	ftnlen	inseqlen;
	char 	*indir;
	ftnlen	indirlen;
	char	*infmt;
	ftnlen	infmtlen;
	char	*inform;
	ftnint	informlen;
	char	*inunf;
	ftnlen	inunflen;
	ftnint	*inrecl;
	ftnint	*innrec;
	char	*inblank;
	ftnlen	inblanklen;
} inlist;

#define VOID void

union Multitype {	/* for multiple entry points */
	shortint h;
	integer i;
	real r;
	doublereal d;
	complex c;
	doublecomplex z;
	};

typedef union Multitype Multitype;

typedef long Long;

struct Vardesc {	/* for Namelist */
	char *name;
	char *addr;
	Long *dims;
	int  type;
	};
typedef struct Vardesc Vardesc;

struct Namelist {
	char *name;
	Vardesc **vars;
	int nvars;
	};
typedef struct Namelist Namelist;

/* procedure parameter types for -A and -C++ */

#define F2C_proc_par_types 1
#ifdef __cplusplus
typedef int /* Unknown procedure type */ (*U_fp)(...);
typedef shortint (*J_fp)(...);
typedef integer (*I_fp)(...);
typedef real (*R_fp)(...);
typedef doublereal (*D_fp)(...), (*E_fp)(...);
typedef /* Complex */ VOID (*C_fp)(...);
typedef /* Double Complex */ VOID (*Z_fp)(...);
typedef logical (*L_fp)(...);
typedef shortlogical (*K_fp)(...);
typedef /* Character */ VOID (*H_fp)(...);
typedef /* Subroutine */ int (*S_fp)(...);
#else
typedef int /* Unknown procedure type */ (*U_fp)();
typedef shortint (*J_fp)();
typedef integer (*I_fp)();
typedef real (*R_fp)();
typedef doublereal (*D_fp)(), (*E_fp)();
typedef /* Complex */ VOID (*C_fp)();
typedef /* Double Complex */ VOID (*Z_fp)();
typedef logical (*L_fp)();
typedef shortlogical (*K_fp)();
typedef /* Character */ VOID (*H_fp)();
typedef /* Subroutine */ int (*S_fp)();
#endif
/* E_fp is for real functions when -R is not specified */
typedef VOID C_f;	/* complex function */
typedef VOID H_f;	/* character function */
typedef VOID Z_f;	/* double complex function */
typedef doublereal E_f;	/* real function with -R not specified */

/* undef any lower-case symbols that your C compiler predefines, e.g.: */

#endif

/* Common Block Declarations */

struct {
    doublereal pii, p7, p7two, c22, s22, pi2;
} cons_;

#define cons_1 cons_

struct {
    doublereal pii, p7, p7two, c22, s22, pi2;
} const_;

#define const_1 const_

struct {
    doublereal pi2, p7;
} con2_;

#define con2_1 con2_

/* Table of constant values */

static integer c__2 = 2;


/* Builtin functions */
static integer pow_ii  PROTO((integer *, integer *));


/* Stripped out all I/O statements. If the size os non-power of two, */
/* then nothing is said, but nothing is done either. */

/* Also stripped out the STOP statements. This could be a problem, just */
/* DON'T call these routines with non power-of-two arrays! DONT DO IT! */

/* Translate via f2c as */
/*    f2c -r8 -a -A -c fast.f */

/* SUBROUTINE:  FAST */
/* REPLACES THE REAL VECTOR B(K), FOR K=1,2,...,N, */
/* WITH ITS FINITE DISCRETE FOURIER TRANSFORM */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE FAST(B, N) >*/
/* Subroutine */ int fast_(doublereal *b, integer *n)
{
    /* System generated locals */
    integer i_1;

    integer n4pow, i, m;
    doublereal t;
    integer nn, it, nt;
    doublereal pi8;
    integer int_;

    /* Parameter adjustments */
    --b;

    /* Function Body */

/* THE DC TERM IS RETURNED IN LOCATION B(1) WITH B(2) SET TO 0. */
/* THEREAFTER THE JTH HARMONIC IS RETURNED AS A COMPLEX */
/* NUMBER STORED AS  B(2*J+1) + I B(2*J+2). */
/* THE N/2 HARMONIC IS RETURNED IN B(N+1) WITH B(N+2) SET TO 0. */
/* HENCE, B MUST BE DIMENSIONED TO SIZE N+2. */
/* THE SUBROUTINE IS CALLED AS  FAST(B,N) WHERE N=2**M AND */
/* B IS THE REAL ARRAY DESCRIBED ABOVE. */

/*<       DIMENSION B(2) >*/
/*<       COMMON /CONS/ PII, P7, P7TWO, C22, S22, PI2 >*/

/*<       PII = 4.*ATAN(1.) >*/
    cons_1.pii = katan(1.) * 4.;
/*<       PI8 = PII/8. >*/
    pi8 = cons_1.pii / 8.;
/*<       P7 = 1./SQRT(2.) >*/
    cons_1.p7 = 1. / ksqrt(2.);
/*<       P7TWO = 2.*P7 >*/
    cons_1.p7two = cons_1.p7 * 2.;
/*<       C22 = COS(PI8) >*/
    cons_1.c22 = kcos(pi8);
/*<       S22 = SIN(PI8) >*/
    cons_1.s22 = ksin(pi8);
/*<       PI2 = 2.*PII >*/
    cons_1.pi2 = cons_1.pii * 2.;
/*<       DO 10 I=1,15 >*/
    for (i = 1; i <= 15; ++i) {
/*<         M = I >*/
	m = i;
/*<         NT = 2**I >*/
	nt = pow_ii(&c__2, &i);
/*<         IF (N.EQ.NT) GO TO 20 >*/
	if (*n == nt) {
	    goto L20;
	}
/*<   10  CONTINUE >*/
/* L10: */
    }
/*<   20  N4POW = M/2 >*/
L20:
    n4pow = m / 2;

/* DO A RADIX 2 ITERATION FIRST IF ONE IS REQUIRED. */

/*<       IF (M-N4POW*2) 40, 40, 30 >*/
    if (m - (n4pow << 1) <= 0) {
	goto L40;
    } else {
	goto L30;
    }
/*<   30  NN = 2 >*/
L30:
    nn = 2;
/*<       INT = N/NN >*/
    int_ = *n / nn;
/*<       CALL FR2TR(INT, B(1), B(INT+1)) >*/
    fr2tr_(&int_, &b[1], &b[int_ + 1]);
/*<       GO TO 50 >*/
    goto L50;
/*<   40  NN = 1 >*/
L40:
    nn = 1;

/* PERFORM RADIX 4 ITERATIONS. */

/*<   50  IF (N4POW.EQ.0) GO TO 70 >*/
L50:
    if (n4pow == 0) {
	goto L70;
    }
/*<       DO 60 IT=1,N4POW >*/
    i_1 = n4pow;
    for (it = 1; it <= i_1; ++it) {
/*<         NN = NN*4 >*/
	nn <<= 2;
/*<         INT = N/NN >*/
	int_ = *n / nn;
/*<         CALL FR4TR(INT, NN, B(1), B(INT+1), B(2*INT+1), B(3*INT+1), >*/
/*<      *      B(1), B(INT+1), B(2*INT+1), B(3*INT+1)) >*/
	fr4tr_(&int_, &nn, &b[1], &b[int_ + 1], &b[(int_ << 1) + 1], &b[int_ *
		 3 + 1], &b[1], &b[int_ + 1], &b[(int_ << 1) + 1], &b[int_ * 
		3 + 1]);
/*<   60  CONTINUE >*/
/* L60: */
    }

/* PERFORM IN-PLACE REORDERING. */

/*<   70  CALL FORD1(M, B) >*/
L70:
    ford1_(&m, &b[1]);
/*<       CALL FORD2(M, B) >*/
    ford2_(&m, &b[1]);
/*<       T = B(2) >*/
    t = b[2];
/*<       B(2) = 0. >*/
    b[2] = 0.;
/*<       B(N+1) = T >*/
    b[*n + 1] = t;
/*<       B(N+2) = 0. >*/
    b[*n + 2] = 0.;
/*<       DO 80 IT=4,N,2 >*/
    i_1 = *n;
    for (it = 4; it <= i_1; it += 2) {
/*<         B(IT) = -B(IT) >*/
	b[it] = -b[it];
/*<   80  CONTINUE >*/
/* L80: */
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* fast_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  FSST */
/* FOURIER SYNTHESIS SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE FSST(B, N) >*/
/* Subroutine */ int fsst_(doublereal *b, integer *n)
{
    /* System generated locals */
    integer i_1;

    /* Local variables */
    integer n4pow, i, m;
    integer nn, it, nt;
    doublereal pi8;
    integer int_;

    /* Parameter adjustments */
    --b;

    /* Function Body */

/* THIS SUBROUTINE SYNTHESIZES THE REAL VECTOR B(K), FOR */
/* K=1,2,...,N, FROM THE FOURIER COEFFICIENTS STORED IN THE */
/* B ARRAY OF SIZE N+2.  THE DC TERM IS IN B(1) WITH B(2) EQUAL */
/* TO  0.  THE JTH HARMONIC IS STORED AS B(2*J+1) + I B(2*J+2). */
/* THE N/2 HARMONIC IS IN B(N+1) WITH B(N+2) EQUAL TO 0. */
/* THE SUBROUTINE IS CALLED AS FSST(B,N) WHERE N=2**M AND */
/* B IS THE REAL ARRAY DISCUSSED ABOVE. */

/*<       DIMENSION B(2) >*/
/*<       COMMON /CONST/ PII, P7, P7TWO, C22, S22, PI2 >*/

/*<       PII = 4.*ATAN(1.) >*/
    const_1.pii = katan(1.) * 4.;
/*<       PI8 = PII/8. >*/
    pi8 = const_1.pii / 8.;
/*<       P7 = 1./SQRT(2.) >*/
    const_1.p7 = 1. / ksqrt(2.);
/*<       P7TWO = 2.*P7 >*/
    const_1.p7two = const_1.p7 * 2.;
/*<       C22 = COS(PI8) >*/
    const_1.c22 = kcos(pi8);
/*<       S22 = SIN(PI8) >*/
    const_1.s22 = ksin(pi8);
/*<       PI2 = 2.*PII >*/
    const_1.pi2 = const_1.pii * 2.;
/*<       DO 10 I=1,15 >*/
    for (i = 1; i <= 15; ++i) {
/*<         M = I >*/
	m = i;
/*<         NT = 2**I >*/
	nt = pow_ii(&c__2, &i);
/*<         IF (N.EQ.NT) GO TO 20 >*/
	if (*n == nt) {
	    goto L20;
	}
/*<   10  CONTINUE >*/
/* L10: */
    }
/*<   20  B(2) = B(N+1) >*/
L20:
    b[2] = b[*n + 1];
/*<       DO 30 I=4,N,2 >*/
    i_1 = *n;
    for (i = 4; i <= i_1; i += 2) {
/*<         B(I) = -B(I) >*/
	b[i] = -b[i];
/*<   30  CONTINUE >*/
/* L30: */
    }

/* SCALE THE INPUT BY N */

/*<       DO 40 I=1,N >*/
    i_1 = *n;
    for (i = 1; i <= i_1; ++i) {
/*<         B(I) = B(I)/FLOAT(N) >*/
	b[i] /= (doublereal) (*n);
/*<   40  CONTINUE >*/
/* L40: */
    }
/*<       N4POW = M/2 >*/
    n4pow = m / 2;

/* SCRAMBLE THE INPUTS */

/*<       CALL FORD2(M, B) >*/
    ford2_(&m, &b[1]);
/*<       CALL FORD1(M, B) >*/
    ford1_(&m, &b[1]);

/*<       IF (N4POW.EQ.0) GO TO 60 >*/
    if (n4pow == 0) {
	goto L60;
    }
/*<       NN = 4*N >*/
    nn = *n << 2;
/*<       DO 50 IT=1,N4POW >*/
    i_1 = n4pow;
    for (it = 1; it <= i_1; ++it) {
/*<         NN = NN/4 >*/
	nn /= 4;
/*<         INT = N/NN >*/
	int_ = *n / nn;
/*<         CALL FR4SYN(INT, NN, B(1), B(INT+1), B(2*INT+1), B(3*INT+1), >*/
/*<      *      B(1), B(INT+1), B(2*INT+1), B(3*INT+1)) >*/
	fr4syn_(&int_, &nn, &b[1], &b[int_ + 1], &b[(int_ << 1) + 1], &b[int_ 
		* 3 + 1], &b[1], &b[int_ + 1], &b[(int_ << 1) + 1], &b[int_ * 
		3 + 1]);
/*<   50  CONTINUE >*/
/* L50: */
    }

/* DO A RADIX 2 ITERATION IF ONE IS REQUIRED */

/*<   60  IF (M-N4POW*2) 80, 80, 70 >*/
L60:
    if (m - (n4pow << 1) <= 0) {
	goto L80;
    } else {
	goto L70;
    }
/*<   70  INT = N/2 >*/
L70:
    int_ = *n / 2;
/*<       CALL FR2TR(INT, B(1), B(INT+1)) >*/
    fr2tr_(&int_, &b[1], &b[int_ + 1]);
/*<   80  RETURN >*/
L80:
    return 0;
/*<       END >*/
} /* fsst_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  FR2TR */
/* RADIX 2 ITERATION SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE FR2TR(INT, B0, B1) >*/
/* Subroutine */ int fr2tr_(integer *int_, doublereal *b0, doublereal *b1)
{
    /* System generated locals */
    integer i_1;

    /* Local variables */
    integer k;
    doublereal t;

    /* Parameter adjustments */
    --b0;
    --b1;

    /* Function Body */
/*<       DIMENSION B0(2), B1(2) >*/
/*<       DO 10 K=1,INT >*/
    i_1 = *int_;
    for (k = 1; k <= i_1; ++k) {
/*<         T = B0(K) + B1(K) >*/
	t = b0[k] + b1[k];
/*<         B1(K) = B0(K) - B1(K) >*/
	b1[k] = b0[k] - b1[k];
/*<         B0(K) = T >*/
	b0[k] = t;
/*<   10  CONTINUE >*/
/* L10: */
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* fr2tr_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  FR4TR */
/* RADIX 4 ITERATION SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE FR4TR(INT, NN, B0, B1, B2, B3, B4, B5, B6, B7) >*/
/* Subroutine */ int fr4tr_(integer *int_, integer *nn, doublereal *b0, 
	doublereal *b1, doublereal *b2, doublereal *b3, doublereal *b4, 
	doublereal *b5, doublereal *b6, doublereal *b7)
{
    /* System generated locals */
    integer i_1, i_2, i_3, i_4, i_5, i_6, i_7, i_8, i_9, i_10, i_11, i_12, 
	    i_13, i_14, i_15, i_16, i_17, i_18, i_19, i_20, i_21, i_22, i_23, 
	    i_24, i_25, i_26, i_27, i_28, i_29, i_30;
    doublereal d_1, d_2;
    static integer equiv_14[15];

    /* Local variables */
    integer j, k;
#define l (equiv_14)
    integer jlast, jthet;
    doublereal c1, piovn;
    integer j01;
#define l1 (equiv_14 + 14)
#define l2 (equiv_14 + 13)
#define l3 (equiv_14 + 12)
#define l4 (equiv_14 + 11)
#define l5 (equiv_14 + 10)
#define l6 (equiv_14 + 9)
#define l7 (equiv_14 + 8)
#define l8 (equiv_14 + 7)
#define l9 (equiv_14 + 6)
    integer j2, j3, j4, j5, j6, j7, j8, j9;
    doublereal t0, t1;
    integer k0;
    doublereal s1, c2, s2, c3, s3;
    integer j00;
    doublereal r1, r5, t2, t6, t3, t7, t4, t5;
    integer j10, j11;
#define l10 (equiv_14 + 5)
#define l11 (equiv_14 + 4)
#define l12 (equiv_14 + 3)
#define l13 (equiv_14 + 2)
#define l14 (equiv_14 + 1)
#define l15 (equiv_14)
    integer ji, j12, j13, jl, j14, kl;
    doublereal pi;
    integer jr;
    doublereal pr, th2, arg;
    integer int4;

    /* Parameter adjustments */
    --b0;
    --b1;
    --b2;
    --b3;
    --b4;
    --b5;
    --b6;
    --b7;

    /* Function Body */
/*<       DIMENSION L(15), B0(2), B1(2), B2(2), B3(2), B4(2), B5(2), B6(2), >*/
/*<      *    B7(2) >*/
/*<       COMMON /CONS/ PII, P7, P7TWO, C22, S22, PI2 >*/
/*<       EQUIVALENCE (L15,L(1)), (L14,L(2)), (L13,L(3)), (L12,L(4)), >*/
/*<      *    (L11,L(5)), (L10,L(6)), (L9,L(7)), (L8,L(8)), (L7,L(9)), >*/
/*<      *    (L6,L(10)), (L5,L(11)), (L4,L(12)), (L3,L(13)), (L2,L(14)), >*/
/*<      *    (L1,L(15)) >*/

/* JTHET IS A REVERSED BINARY COUNTER, JR STEPS TWO AT A TIME TO */
/* LOCATE THE REAL PARTS OF INTERMEDIATE RESULTS, AND JI LOCATES */
/* THE IMAGINARY PART CORRESPONDING TO JR. */

/*<       L(1) = NN/4 >*/
    l[0] = *nn / 4;
/*<       DO 40 K=2,15 >*/
    for (k = 2; k <= 15; ++k) {
/*<         IF (L(K-1)-2) 10, 20, 30 >*/
	if ((i_1 = l[k - 2] - 2) < 0) {
	    goto L10;
	} else if (i_1 == 0) {
	    goto L20;
	} else {
	    goto L30;
	}
/*<   10    L(K-1) = 2 >*/
L10:
	l[k - 2] = 2;
/*<   20    L(K) = 2 >*/
L20:
	l[k - 1] = 2;
/*<         GO TO 40 >*/
	goto L40;
/*<   30    L(K) = L(K-1)/2 >*/
L30:
	l[k - 1] = l[k - 2] / 2;
/*<   40  CONTINUE >*/
L40:
    ;}

/*<       PIOVN = PII/FLOAT(NN) >*/
    piovn = cons_1.pii / (doublereal) (*nn);
/*<       JI = 3 >*/
    ji = 3;
/*<       JL = 2 >*/
    jl = 2;
/*<       JR = 2 >*/
    jr = 2;

/*<       DO 120 J1=2,L1,2 >*/
    i_1 = *l1;
    for (j01 = 2; j01 <= i_1; j01 += 2) {
/*<       DO 120 J2=J1,L2,L1 >*/
	i_2 = *l2;
	i_3 = *l1;
	for (j2 = j01; i_3 < 0 ? j2 >= i_2 : j2 <= i_2; j2 += i_3) {
/*<       DO 120 J3=J2,L3,L2 >*/
	    i_4 = *l3;
	    i_5 = *l2;
	    for (j3 = j2; i_5 < 0 ? j3 >= i_4 : j3 <= i_4; j3 += i_5) {
/*<       DO 120 J4=J3,L4,L3 >*/
		i_6 = *l4;
		i_7 = *l3;
		for (j4 = j3; i_7 < 0 ? j4 >= i_6 : j4 <= i_6; j4 += i_7) {
/*<       DO 120 J5=J4,L5,L4 >*/
		    i_8 = *l5;
		    i_9 = *l4;
		    for (j5 = j4; i_9 < 0 ? j5 >= i_8 : j5 <= i_8; j5 += i_9) 
			    {
/*<       DO 120 J6=J5,L6,L5 >*/
			i_10 = *l6;
			i_11 = *l5;
			for (j6 = j5; i_11 < 0 ? j6 >= i_10 : j6 <= i_10; j6 
				+= i_11) {
/*<       DO 120 J7=J6,L7,L6 >*/
			    i_12 = *l7;
			    i_13 = *l6;
			    for (j7 = j6; i_13 < 0 ? j7 >= i_12 : j7 <= i_12; 
				    j7 += i_13) {
/*<       DO 120 J8=J7,L8,L7 >*/
				i_14 = *l8;
				i_15 = *l7;
				for (j8 = j7; i_15 < 0 ? j8 >= i_14 : j8 <= 
					i_14; j8 += i_15) {
/*<       DO 120 J9=J8,L9,L8 >*/
				    i_16 = *l9;
				    i_17 = *l8;
				    for (j9 = j8; i_17 < 0 ? j9 >= i_16 : j9 
					    <= i_16; j9 += i_17) {
/*<       DO 120 J10=J9,L10,L9 >*/
					i_18 = *l10;
					i_19 = *l9;
					for (j10 = j9; i_19 < 0 ? j10 >= i_18 
						: j10 <= i_18; j10 += i_19) {
/*<       DO 120 J11=J10,L11,L10 >*/
					    i_20 = *l11;
					    i_21 = *l10;
					    for (j11 = j10; i_21 < 0 ? j11 >= 
						    i_20 : j11 <= i_20; j11 +=
						     i_21) {
/*<       DO 120 J12=J11,L12,L11 >*/
			  i_22 = *l12;
			  i_23 = *l11;
			  for (j12 = j11; i_23 < 0 ? j12 >= i_22 : j12 <= 
				  i_22; j12 += i_23) {
/*<       DO 120 J13=J12,L13,L12 >*/
			      i_24 = *l13;
			      i_25 = *l12;
			      for (j13 = j12; i_25 < 0 ? j13 >= i_24 : j13 <= 
				      i_24; j13 += i_25) {
/*<       DO 120 J14=J13,L14,L13 >*/
				  i_26 = *l14;
				  i_27 = *l13;
				  for (j14 = j13; i_27 < 0 ? j14 >= i_26 : 
					  j14 <= i_26; j14 += i_27) {
/*<       DO 120 JTHET=J14,L15,L14 >*/
				      i_28 = *l15;
				      i_29 = *l14;
				      for (jthet = j14; i_29 < 0 ? jthet >= 
					      i_28 : jthet <= i_28; jthet += 
					      i_29) {
/*<         TH2 = JTHET - 2 >*/
					  th2 = (doublereal) (jthet - 2);
/*<         IF (TH2) 50, 50, 90 >*/
					  if (th2 <= 0.) {
			goto L50;
					  } else {
			goto L90;
					  }
/*<   50    DO 60 K=1,INT >*/
L50:
					  i_30 = *int_;
					  for (k = 1; k <= i_30; ++k) {
/*<           T0 = B0(K) + B2(K) >*/
			t0 = b0[k] + b2[k];
/*<           T1 = B1(K) + B3(K) >*/
			t1 = b1[k] + b3[k];
/*<           B2(K) = B0(K) - B2(K) >*/
			b2[k] = b0[k] - b2[k];
/*<           B3(K) = B1(K) - B3(K) >*/
			b3[k] = b1[k] - b3[k];
/*<           B0(K) = T0 + T1 >*/
			b0[k] = t0 + t1;
/*<           B1(K) = T0 - T1 >*/
			b1[k] = t0 - t1;
/*<   60    CONTINUE >*/
/* L60: */
					  }

/*<         IF (NN-4) 120, 120, 70 >*/
					  if (*nn - 4 <= 0) {
			goto L120;
					  } else {
			goto L70;
					  }
/*<   70    K0 = INT*4 + 1 >*/
L70:
					  k0 = (*int_ << 2) + 1;
/*<         KL = K0 + INT - 1 >*/
					  kl = k0 + *int_ - 1;
/*<         DO 80 K=K0,KL >*/
					  i_30 = kl;
					  for (k = k0; k <= i_30; ++k) {
/*<           PR = P7*(B1(K)-B3(K)) >*/
			pr = cons_1.p7 * (b1[k] - b3[k]);
/*<           PI = P7*(B1(K)+B3(K)) >*/
			pi = cons_1.p7 * (b1[k] + b3[k]);
/*<           B3(K) = B2(K) + PI >*/
			b3[k] = b2[k] + pi;
/*<           B1(K) = PI - B2(K) >*/
			b1[k] = pi - b2[k];
/*<           B2(K) = B0(K) - PR >*/
			b2[k] = b0[k] - pr;
/*<           B0(K) = B0(K) + PR >*/
			b0[k] += pr;
/*<   80    CONTINUE >*/
/* L80: */
					  }
/*<         GO TO 120 >*/
					  goto L120;

/*<   90    ARG = TH2*PIOVN >*/
L90:
					  arg = th2 * piovn;
/*<         C1 = COS(ARG) >*/
					  c1 = kcos(arg);
/*<         S1 = SIN(ARG) >*/
					  s1 = ksin(arg);
/*<         C2 = C1**2 - S1**2 >*/
/* Computing 2nd power */
					  d_1 = c1;
/* Computing 2nd power */
					  d_2 = s1;
					  c2 = d_1 * d_1 - d_2 * d_2;
/*<         S2 = C1*S1 + C1*S1 >*/
					  s2 = c1 * s1 + c1 * s1;
/*<         C3 = C1*C2 - S1*S2 >*/
					  c3 = c1 * c2 - s1 * s2;
/*<         S3 = C2*S1 + S2*C1 >*/
					  s3 = c2 * s1 + s2 * c1;

/*<         INT4 = INT*4 >*/
					  int4 = *int_ << 2;
/*<         J0 = JR*INT4 + 1 >*/
					  j00 = jr * int4 + 1;
/*<         K0 = JI*INT4 + 1 >*/
					  k0 = ji * int4 + 1;
/*<         JLAST = J0 + INT - 1 >*/
					  jlast = j00 + *int_ - 1;
/*<         DO 100 J=J0,JLAST >*/
					  i_30 = jlast;
					  for (j = j00; j <= i_30; ++j) {
/*<           K = K0 + J - J0 >*/
			k = k0 + j - j00;
/*<           R1 = B1(J)*C1 - B5(K)*S1 >*/
			r1 = b1[j] * c1 - b5[k] * s1;
/*<           R5 = B1(J)*S1 + B5(K)*C1 >*/
			r5 = b1[j] * s1 + b5[k] * c1;
/*<           T2 = B2(J)*C2 - B6(K)*S2 >*/
			t2 = b2[j] * c2 - b6[k] * s2;
/*<           T6 = B2(J)*S2 + B6(K)*C2 >*/
			t6 = b2[j] * s2 + b6[k] * c2;
/*<           T3 = B3(J)*C3 - B7(K)*S3 >*/
			t3 = b3[j] * c3 - b7[k] * s3;
/*<           T7 = B3(J)*S3 + B7(K)*C3 >*/
			t7 = b3[j] * s3 + b7[k] * c3;
/*<           T0 = B0(J) + T2 >*/
			t0 = b0[j] + t2;
/*<           T4 = B4(K) + T6 >*/
			t4 = b4[k] + t6;
/*<           T2 = B0(J) - T2 >*/
			t2 = b0[j] - t2;
/*<           T6 = B4(K) - T6 >*/
			t6 = b4[k] - t6;
/*<           T1 = R1 + T3 >*/
			t1 = r1 + t3;
/*<           T5 = R5 + T7 >*/
			t5 = r5 + t7;
/*<           T3 = R1 - T3 >*/
			t3 = r1 - t3;
/*<           T7 = R5 - T7 >*/
			t7 = r5 - t7;
/*<           B0(J) = T0 + T1 >*/
			b0[j] = t0 + t1;
/*<           B7(K) = T4 + T5 >*/
			b7[k] = t4 + t5;
/*<           B6(K) = T0 - T1 >*/
			b6[k] = t0 - t1;
/*<           B1(J) = T5 - T4 >*/
			b1[j] = t5 - t4;
/*<           B2(J) = T2 - T7 >*/
			b2[j] = t2 - t7;
/*<           B5(K) = T6 + T3 >*/
			b5[k] = t6 + t3;
/*<           B4(K) = T2 + T7 >*/
			b4[k] = t2 + t7;
/*<           B3(J) = T3 - T6 >*/
			b3[j] = t3 - t6;
/*<  100    CONTINUE >*/
/* L100: */
					  }

/*<         JR = JR + 2 >*/
					  jr += 2;
/*<         JI = JI - 2 >*/
					  ji += -2;
/*<         IF (JI-JL) 110, 110, 120 >*/
					  if (ji - jl <= 0) {
			goto L110;
					  } else {
			goto L120;
					  }
/*<  110    JI = 2*JR - 1 >*/
L110:
					  ji = (jr << 1) - 1;
/*<         JL = JR >*/
					  jl = jr;
/*<  120  CONTINUE >*/
L120:
				      ;}
				  }
			      }
			  }
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* fr4tr_ */

#undef l15
#undef l14
#undef l13
#undef l12
#undef l11
#undef l10
#undef l9
#undef l8
#undef l7
#undef l6
#undef l5
#undef l4
#undef l3
#undef l2
#undef l1
#undef l



/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  FR4SYN */
/* RADIX 4 SYNTHESIS */
/* ----------------------------------------------------------------------- */


/*<       SUBROUTINE FR4SYN(INT, NN, B0, B1, B2, B3, B4, B5, B6, B7) >*/
/* Subroutine */ int fr4syn_(integer *int_, integer *nn, doublereal *b0, 
	doublereal *b1, doublereal *b2, doublereal *b3, doublereal *b4, 
	doublereal *b5, doublereal *b6, doublereal *b7)
{
    /* System generated locals */
    integer i_1, i_2, i_3, i_4, i_5, i_6, i_7, i_8, i_9, i_10, i_11, i_12, 
	    i_13, i_14, i_15, i_16, i_17, i_18, i_19, i_20, i_21, i_22, i_23, 
	    i_24, i_25, i_26, i_27, i_28, i_29, i_30;
    doublereal d_1, d_2;
    static integer equiv_14[15];

    /* Local variables */
    integer j, k;
#define l (equiv_14)
    integer jlast, jthet;
    doublereal c1, piovn;
    integer j01;
#define l1 (equiv_14 + 14)
#define l2 (equiv_14 + 13)
#define l3 (equiv_14 + 12)
#define l4 (equiv_14 + 11)
#define l5 (equiv_14 + 10)
#define l6 (equiv_14 + 9)
#define l7 (equiv_14 + 8)
#define l8 (equiv_14 + 7)
#define l9 (equiv_14 + 6)
    integer j2, j3, j4, j5, j6, j7, j8, j9;
    doublereal t0, t1, t2, t3;
    integer k0;
    doublereal s1, c2, s2, c3, s3;
    integer j00;
    doublereal t4, t5, t6, t7;
    integer j10, j11;
#define l10 (equiv_14 + 5)
#define l11 (equiv_14 + 4)
#define l12 (equiv_14 + 3)
#define l13 (equiv_14 + 2)
#define l14 (equiv_14 + 1)
#define l15 (equiv_14)
    integer ji, j12, jl, j13, j14, kl, jr;
    doublereal th2, arg;
    integer int4;

    /* Parameter adjustments */
    --b0;
    --b1;
    --b2;
    --b3;
    --b4;
    --b5;
    --b6;
    --b7;

    /* Function Body */
/*<       DIMENSION L(15), B0(2), B1(2), B2(2), B3(2), B4(2), B5(2), B6(2), >*/
/*<      *    B7(2) >*/
/*<       COMMON /CONST/ PII, P7, P7TWO, C22, S22, PI2 >*/
/*<       EQUIVALENCE (L15,L(1)), (L14,L(2)), (L13,L(3)), (L12,L(4)), >*/
/*<      *    (L11,L(5)), (L10,L(6)), (L9,L(7)), (L8,L(8)), (L7,L(9)), >*/
/*<      *    (L6,L(10)), (L5,L(11)), (L4,L(12)), (L3,L(13)), (L2,L(14)), >*/
/*<      *    (L1,L(15)) >*/

/*<       L(1) = NN/4 >*/
    l[0] = *nn / 4;
/*<       DO 40 K=2,15 >*/
    for (k = 2; k <= 15; ++k) {
/*<         IF (L(K-1)-2) 10, 20, 30 >*/
	if ((i_1 = l[k - 2] - 2) < 0) {
	    goto L10;
	} else if (i_1 == 0) {
	    goto L20;
	} else {
	    goto L30;
	}
/*<   10    L(K-1) = 2 >*/
L10:
	l[k - 2] = 2;
/*<   20    L(K) = 2 >*/
L20:
	l[k - 1] = 2;
/*<         GO TO 40 >*/
	goto L40;
/*<   30    L(K) = L(K-1)/2 >*/
L30:
	l[k - 1] = l[k - 2] / 2;
/*<   40  CONTINUE >*/
L40:
    ;}

/*<       PIOVN = PII/FLOAT(NN) >*/
    piovn = const_1.pii / (doublereal) (*nn);
/*<       JI = 3 >*/
    ji = 3;
/*<       JL = 2 >*/
    jl = 2;
/*<       JR = 2 >*/
    jr = 2;

/*<       DO 120 J1=2,L1,2 >*/
    i_1 = *l1;
    for (j01 = 2; j01 <= i_1; j01 += 2) {
/*<       DO 120 J2=J1,L2,L1 >*/
	i_2 = *l2;
	i_3 = *l1;
	for (j2 = j01; i_3 < 0 ? j2 >= i_2 : j2 <= i_2; j2 += i_3) {
/*<       DO 120 J3=J2,L3,L2 >*/
	    i_4 = *l3;
	    i_5 = *l2;
	    for (j3 = j2; i_5 < 0 ? j3 >= i_4 : j3 <= i_4; j3 += i_5) {
/*<       DO 120 J4=J3,L4,L3 >*/
		i_6 = *l4;
		i_7 = *l3;
		for (j4 = j3; i_7 < 0 ? j4 >= i_6 : j4 <= i_6; j4 += i_7) {
/*<       DO 120 J5=J4,L5,L4 >*/
		    i_8 = *l5;
		    i_9 = *l4;
		    for (j5 = j4; i_9 < 0 ? j5 >= i_8 : j5 <= i_8; j5 += i_9) 
			    {
/*<       DO 120 J6=J5,L6,L5 >*/
			i_10 = *l6;
			i_11 = *l5;
			for (j6 = j5; i_11 < 0 ? j6 >= i_10 : j6 <= i_10; j6 
				+= i_11) {
/*<       DO 120 J7=J6,L7,L6 >*/
			    i_12 = *l7;
			    i_13 = *l6;
			    for (j7 = j6; i_13 < 0 ? j7 >= i_12 : j7 <= i_12; 
				    j7 += i_13) {
/*<       DO 120 J8=J7,L8,L7 >*/
				i_14 = *l8;
				i_15 = *l7;
				for (j8 = j7; i_15 < 0 ? j8 >= i_14 : j8 <= 
					i_14; j8 += i_15) {
/*<       DO 120 J9=J8,L9,L8 >*/
				    i_16 = *l9;
				    i_17 = *l8;
				    for (j9 = j8; i_17 < 0 ? j9 >= i_16 : j9 
					    <= i_16; j9 += i_17) {
/*<       DO 120 J10=J9,L10,L9 >*/
					i_18 = *l10;
					i_19 = *l9;
					for (j10 = j9; i_19 < 0 ? j10 >= i_18 
						: j10 <= i_18; j10 += i_19) {
/*<       DO 120 J11=J10,L11,L10 >*/
					    i_20 = *l11;
					    i_21 = *l10;
					    for (j11 = j10; i_21 < 0 ? j11 >= 
						    i_20 : j11 <= i_20; j11 +=
						     i_21) {
/*<       DO 120 J12=J11,L12,L11 >*/
			  i_22 = *l12;
			  i_23 = *l11;
			  for (j12 = j11; i_23 < 0 ? j12 >= i_22 : j12 <= 
				  i_22; j12 += i_23) {
/*<       DO 120 J13=J12,L13,L12 >*/
			      i_24 = *l13;
			      i_25 = *l12;
			      for (j13 = j12; i_25 < 0 ? j13 >= i_24 : j13 <= 
				      i_24; j13 += i_25) {
/*<       DO 120 J14=J13,L14,L13 >*/
				  i_26 = *l14;
				  i_27 = *l13;
				  for (j14 = j13; i_27 < 0 ? j14 >= i_26 : 
					  j14 <= i_26; j14 += i_27) {
/*<       DO 120 JTHET=J14,L15,L14 >*/
				      i_28 = *l15;
				      i_29 = *l14;
				      for (jthet = j14; i_29 < 0 ? jthet >= 
					      i_28 : jthet <= i_28; jthet += 
					      i_29) {
/*<         TH2 = JTHET - 2 >*/
					  th2 = (doublereal) (jthet - 2);
/*<         IF (TH2) 50, 50, 90 >*/
					  if (th2 <= 0.) {
			goto L50;
					  } else {
			goto L90;
					  }
/*<   50    DO 60 K=1,INT >*/
L50:
					  i_30 = *int_;
					  for (k = 1; k <= i_30; ++k) {
/*<           T0 = B0(K) + B1(K) >*/
			t0 = b0[k] + b1[k];
/*<           T1 = B0(K) - B1(K) >*/
			t1 = b0[k] - b1[k];
/*<           T2 = B2(K)*2.0 >*/
			t2 = b2[k] * 2.;
/*<           T3 = B3(K)*2.0 >*/
			t3 = b3[k] * 2.;
/*<           B0(K) = T0 + T2 >*/
			b0[k] = t0 + t2;
/*<           B2(K) = T0 - T2 >*/
			b2[k] = t0 - t2;
/*<           B1(K) = T1 + T3 >*/
			b1[k] = t1 + t3;
/*<           B3(K) = T1 - T3 >*/
			b3[k] = t1 - t3;
/*<   60    CONTINUE >*/
/* L60: */
					  }

/*<         IF (NN-4) 120, 120, 70 >*/
					  if (*nn - 4 <= 0) {
			goto L120;
					  } else {
			goto L70;
					  }
/*<   70    K0 = INT*4 + 1 >*/
L70:
					  k0 = (*int_ << 2) + 1;
/*<         KL = K0 + INT - 1 >*/
					  kl = k0 + *int_ - 1;
/*<         DO 80 K=K0,KL >*/
					  i_30 = kl;
					  for (k = k0; k <= i_30; ++k) {
/*<           T2 = B0(K) - B2(K) >*/
			t2 = b0[k] - b2[k];
/*<           T3 = B1(K) + B3(K) >*/
			t3 = b1[k] + b3[k];
/*<           B0(K) = (B0(K)+B2(K))*2.0 >*/
			b0[k] = (b0[k] + b2[k]) * 2.;
/*<           B2(K) = (B3(K)-B1(K))*2.0 >*/
			b2[k] = (b3[k] - b1[k]) * 2.;
/*<           B1(K) = (T2+T3)*P7TWO >*/
			b1[k] = (t2 + t3) * const_1.p7two;
/*<           B3(K) = (T3-T2)*P7TWO >*/
			b3[k] = (t3 - t2) * const_1.p7two;
/*<   80    CONTINUE >*/
/* L80: */
					  }
/*<         GO TO 120 >*/
					  goto L120;
/*<   90    ARG = TH2*PIOVN >*/
L90:
					  arg = th2 * piovn;
/*<         C1 = COS(ARG) >*/
					  c1 = kcos(arg);
/*<         S1 = -SIN(ARG) >*/
					  s1 = -ksin(arg);
/*<         C2 = C1**2 - S1**2 >*/
/* Computing 2nd power */
					  d_1 = c1;
/* Computing 2nd power */
					  d_2 = s1;
					  c2 = d_1 * d_1 - d_2 * d_2;
/*<         S2 = C1*S1 + C1*S1 >*/
					  s2 = c1 * s1 + c1 * s1;
/*<         C3 = C1*C2 - S1*S2 >*/
					  c3 = c1 * c2 - s1 * s2;
/*<         S3 = C2*S1 + S2*C1 >*/
					  s3 = c2 * s1 + s2 * c1;

/*<         INT4 = INT*4 >*/
					  int4 = *int_ << 2;
/*<         J0 = JR*INT4 + 1 >*/
					  j00 = jr * int4 + 1;
/*<         K0 = JI*INT4 + 1 >*/
					  k0 = ji * int4 + 1;
/*<         JLAST = J0 + INT - 1 >*/
					  jlast = j00 + *int_ - 1;
/*<         DO 100 J=J0,JLAST >*/
					  i_30 = jlast;
					  for (j = j00; j <= i_30; ++j) {
/*<           K = K0 + J - J0 >*/
			k = k0 + j - j00;
/*<           T0 = B0(J) + B6(K) >*/
			t0 = b0[j] + b6[k];
/*<           T1 = B7(K) - B1(J) >*/
			t1 = b7[k] - b1[j];
/*<           T2 = B0(J) - B6(K) >*/
			t2 = b0[j] - b6[k];
/*<           T3 = B7(K) + B1(J) >*/
			t3 = b7[k] + b1[j];
/*<           T4 = B2(J) + B4(K) >*/
			t4 = b2[j] + b4[k];
/*<           T5 = B5(K) - B3(J) >*/
			t5 = b5[k] - b3[j];
/*<           T6 = B5(K) + B3(J) >*/
			t6 = b5[k] + b3[j];
/*<           T7 = B4(K) - B2(J) >*/
			t7 = b4[k] - b2[j];
/*<           B0(J) = T0 + T4 >*/
			b0[j] = t0 + t4;
/*<           B4(K) = T1 + T5 >*/
			b4[k] = t1 + t5;
/*<           B1(J) = (T2+T6)*C1 - (T3+T7)*S1 >*/
			b1[j] = (t2 + t6) * c1 - (t3 + t7) * s1;
/*<           B5(K) = (T2+T6)*S1 + (T3+T7)*C1 >*/
			b5[k] = (t2 + t6) * s1 + (t3 + t7) * c1;
/*<           B2(J) = (T0-T4)*C2 - (T1-T5)*S2 >*/
			b2[j] = (t0 - t4) * c2 - (t1 - t5) * s2;
/*<           B6(K) = (T0-T4)*S2 + (T1-T5)*C2 >*/
			b6[k] = (t0 - t4) * s2 + (t1 - t5) * c2;
/*<           B3(J) = (T2-T6)*C3 - (T3-T7)*S3 >*/
			b3[j] = (t2 - t6) * c3 - (t3 - t7) * s3;
/*<           B7(K) = (T2-T6)*S3 + (T3-T7)*C3 >*/
			b7[k] = (t2 - t6) * s3 + (t3 - t7) * c3;
/*<  100    CONTINUE >*/
/* L100: */
					  }
/*<         JR = JR + 2 >*/
					  jr += 2;
/*<         JI = JI - 2 >*/
					  ji += -2;
/*<         IF (JI-JL) 110, 110, 120 >*/
					  if (ji - jl <= 0) {
			goto L110;
					  } else {
			goto L120;
					  }
/*<  110    JI = 2*JR - 1 >*/
L110:
					  ji = (jr << 1) - 1;
/*<         JL = JR >*/
					  jl = jr;
/*<  120  CONTINUE >*/
L120:
				      ;}
				  }
			      }
			  }
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* fr4syn_ */

#undef l15
#undef l14
#undef l13
#undef l12
#undef l11
#undef l10
#undef l9
#undef l8
#undef l7
#undef l6
#undef l5
#undef l4
#undef l3
#undef l2
#undef l1
#undef l



/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  FORD1 */
/* IN-PLACE REORDERING SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE FORD1(M, B) >*/
/* Subroutine */ int ford1_(integer *m, doublereal *b)
{
    /* System generated locals */
    integer i_1;

    /* Local variables */
    integer j, k, n;
    doublereal t;
    integer kl;

    /* Parameter adjustments */
    --b;

    /* Function Body */
/*<       DIMENSION B(2) >*/

/*<       K = 4 >*/
    k = 4;
/*<       KL = 2 >*/
    kl = 2;
/*<       N = 2**M >*/
    n = pow_ii(&c__2, m);
/*<       DO 40 J=4,N,2 >*/
    i_1 = n;
    for (j = 4; j <= i_1; j += 2) {
/*<         IF (K-J) 20, 20, 10 >*/
	if (k - j <= 0) {
	    goto L20;
	} else {
	    goto L10;
	}
/*<   10    T = B(J) >*/
L10:
	t = b[j];
/*<         B(J) = B(K) >*/
	b[j] = b[k];
/*<         B(K) = T >*/
	b[k] = t;
/*<   20    K = K - 2 >*/
L20:
	k += -2;
/*<         IF (K-KL) 30, 30, 40 >*/
	if (k - kl <= 0) {
	    goto L30;
	} else {
	    goto L40;
	}
/*<   30    K = 2*J >*/
L30:
	k = j << 1;
/*<         KL = J >*/
	kl = j;
/*<   40  CONTINUE >*/
L40:
    ;}
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* ford1_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  FORD2 */
/* IN-PLACE REORDERING SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE FORD2(M, B) >*/
/* Subroutine */ int ford2_(integer *m, doublereal *b)
{
    /* System generated locals */
    integer i_1, i_2, i_3, i_4, i_5, i_6, i_7, i_8, i_9, i_10, i_11, i_12, 
	    i_13, i_14, i_15, i_16, i_17, i_18, i_19, i_20, i_21, i_22, i_23, 
	    i_24, i_25, i_26, i_27, i_28, i_29;
    static integer equiv_14[15];

    /* Local variables */
    integer k;
#define l (equiv_14)
    integer n;
    doublereal t;
    integer j01, j2;
#define l1 (equiv_14 + 14)
#define l2 (equiv_14 + 13)
#define l3 (equiv_14 + 12)
#define l4 (equiv_14 + 11)
#define l5 (equiv_14 + 10)
#define l6 (equiv_14 + 9)
#define l7 (equiv_14 + 8)
#define l8 (equiv_14 + 7)
#define l9 (equiv_14 + 6)
    integer j3, j4, j5, j6, j7, j8, j9, j10, j11;
#define l10 (equiv_14 + 5)
#define l11 (equiv_14 + 4)
#define l12 (equiv_14 + 3)
#define l13 (equiv_14 + 2)
#define l14 (equiv_14 + 1)
#define l15 (equiv_14)
    integer ij, j12, j13, j14, ji;

    /* Parameter adjustments */
    --b;

    /* Function Body */
/*<       DIMENSION L(15), B(2) >*/
/*<       EQUIVALENCE (L15,L(1)), (L14,L(2)), (L13,L(3)), (L12,L(4)), >*/
/*<      *    (L11,L(5)), (L10,L(6)), (L9,L(7)), (L8,L(8)), (L7,L(9)), >*/
/*<      *    (L6,L(10)), (L5,L(11)), (L4,L(12)), (L3,L(13)), (L2,L(14)), >*/
/*<      *    (L1,L(15)) >*/
/*<       N = 2**M >*/
    n = pow_ii(&c__2, m);
/*<       L(1) = N >*/
    l[0] = n;
/*<       DO 10 K=2,M >*/
    i_1 = *m;
    for (k = 2; k <= i_1; ++k) {
/*<         L(K) = L(K-1)/2 >*/
	l[k - 1] = l[k - 2] / 2;
/*<   10  CONTINUE >*/
/* L10: */
    }
/*<       DO 20 K=M,14 >*/
    for (k = *m; k <= 14; ++k) {
/*<         L(K+1) = 2 >*/
	l[k] = 2;
/*<   20  CONTINUE >*/
/* L20: */
    }
/*<       IJ = 2 >*/
    ij = 2;
/*<       DO 40 J1=2,L1,2 >*/
    i_1 = *l1;
    for (j01 = 2; j01 <= i_1; j01 += 2) {
/*<       DO 40 J2=J1,L2,L1 >*/
	i_2 = *l2;
	i_3 = *l1;
	for (j2 = j01; i_3 < 0 ? j2 >= i_2 : j2 <= i_2; j2 += i_3) {
/*<       DO 40 J3=J2,L3,L2 >*/
	    i_4 = *l3;
	    i_5 = *l2;
	    for (j3 = j2; i_5 < 0 ? j3 >= i_4 : j3 <= i_4; j3 += i_5) {
/*<       DO 40 J4=J3,L4,L3 >*/
		i_6 = *l4;
		i_7 = *l3;
		for (j4 = j3; i_7 < 0 ? j4 >= i_6 : j4 <= i_6; j4 += i_7) {
/*<       DO 40 J5=J4,L5,L4 >*/
		    i_8 = *l5;
		    i_9 = *l4;
		    for (j5 = j4; i_9 < 0 ? j5 >= i_8 : j5 <= i_8; j5 += i_9) 
			    {
/*<       DO 40 J6=J5,L6,L5 >*/
			i_10 = *l6;
			i_11 = *l5;
			for (j6 = j5; i_11 < 0 ? j6 >= i_10 : j6 <= i_10; j6 
				+= i_11) {
/*<       DO 40 J7=J6,L7,L6 >*/
			    i_12 = *l7;
			    i_13 = *l6;
			    for (j7 = j6; i_13 < 0 ? j7 >= i_12 : j7 <= i_12; 
				    j7 += i_13) {
/*<       DO 40 J8=J7,L8,L7 >*/
				i_14 = *l8;
				i_15 = *l7;
				for (j8 = j7; i_15 < 0 ? j8 >= i_14 : j8 <= 
					i_14; j8 += i_15) {
/*<       DO 40 J9=J8,L9,L8 >*/
				    i_16 = *l9;
				    i_17 = *l8;
				    for (j9 = j8; i_17 < 0 ? j9 >= i_16 : j9 
					    <= i_16; j9 += i_17) {
/*<       DO 40 J10=J9,L10,L9 >*/
					i_18 = *l10;
					i_19 = *l9;
					for (j10 = j9; i_19 < 0 ? j10 >= i_18 
						: j10 <= i_18; j10 += i_19) {
/*<       DO 40 J11=J10,L11,L10 >*/
					    i_20 = *l11;
					    i_21 = *l10;
					    for (j11 = j10; i_21 < 0 ? j11 >= 
						    i_20 : j11 <= i_20; j11 +=
						     i_21) {
/*<       DO 40 J12=J11,L12,L11 >*/
			  i_22 = *l12;
			  i_23 = *l11;
			  for (j12 = j11; i_23 < 0 ? j12 >= i_22 : j12 <= 
				  i_22; j12 += i_23) {
/*<       DO 40 J13=J12,L13,L12 >*/
			      i_24 = *l13;
			      i_25 = *l12;
			      for (j13 = j12; i_25 < 0 ? j13 >= i_24 : j13 <= 
				      i_24; j13 += i_25) {
/*<       DO 40 J14=J13,L14,L13 >*/
				  i_26 = *l14;
				  i_27 = *l13;
				  for (j14 = j13; i_27 < 0 ? j14 >= i_26 : 
					  j14 <= i_26; j14 += i_27) {
/*<       DO 40 JI=J14,L15,L14 >*/
				      i_28 = *l15;
				      i_29 = *l14;
				      for (ji = j14; i_29 < 0 ? ji >= i_28 : 
					      ji <= i_28; ji += i_29) {
/*<         IF (IJ-JI) 30, 40, 40 >*/
					  if (ij - ji >= 0) {
			goto L40;
					  } else {
			goto L30;
					  }
/*<   30    T = B(IJ-1) >*/
L30:
					  t = b[ij - 1];
/*<         B(IJ-1) = B(JI-1) >*/
					  b[ij - 1] = b[ji - 1];
/*<         B(JI-1) = T >*/
					  b[ji - 1] = t;
/*<         T = B(IJ) >*/
					  t = b[ij];
/*<         B(IJ) = B(JI) >*/
					  b[ij] = b[ji];
/*<         B(JI) = T >*/
					  b[ji] = t;
/*<   40    IJ = IJ + 2 >*/
L40:
					  ij += 2;
				      }
				  }
			      }
			  }
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* ford2_ */

#undef l15
#undef l14
#undef l13
#undef l12
#undef l11
#undef l10
#undef l9
#undef l8
#undef l7
#undef l6
#undef l5
#undef l4
#undef l3
#undef l2
#undef l1
#undef l


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  FFT842 */
/* FAST FOURIER TRANSFORM FOR N=2**M */
/* COMPLEX INPUT */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE FFT842(IN, N, X, Y) >*/
/* Subroutine */ int fft842_(integer *in, integer *n, doublereal *x, 
	doublereal *y)
{
    /* System generated locals */
    integer i_1, i_2, i_3, i_4, i_5, i_6, i_7, i_8, i_9, i_10, i_11, i_12, 
	    i_13, i_14, i_15, i_16, i_17, i_18, i_19, i_20, i_21, i_22, i_23, 
	    i_24, i_25, i_26, i_27, i_28, i_29;
    static integer equiv_14[15];

    /* Local variables */
    integer n2pow, i, j, n8pow;
#define l (equiv_14)
    integer m = 0;
    doublereal r;
    integer lengt, ipass, nthpo, j01, j2;
#define l1 (equiv_14 + 14)
#define l2 (equiv_14 + 13)
#define l3 (equiv_14 + 12)
#define l4 (equiv_14 + 11)
#define l5 (equiv_14 + 10)
#define l6 (equiv_14 + 9)
#define l7 (equiv_14 + 8)
#define l8 (equiv_14 + 7)
#define l9 (equiv_14 + 6)
    integer j3, j4, nxtlt, j5, j6, j7, j8, j9, j10, j11;
#define l10 (equiv_14 + 5)
#define l11 (equiv_14 + 4)
#define l12 (equiv_14 + 3)
#define l13 (equiv_14 + 2)
#define l14 (equiv_14 + 1)
#define l15 (equiv_14)
    integer ij;
    doublereal fn;
    integer j12, j13, j14, ji;
    doublereal fi;
    integer nt;

    /* Parameter adjustments */
    --x;
    --y;

    /* Function Body */

/* THIS PROGRAM REPLACES THE VECTOR Z=X+IY BY ITS  FINITE */
/* DISCRETE, COMPLEX FOURIER TRANSFORM IF IN=0.  THE INVERSE TRANSFORM */
/* IS CALCULATED FOR IN=1.  IT PERFORMS AS MANY BASE */
/* 8 ITERATIONS AS POSSIBLE AND THEN FINISHES WITH A BASE 4 ITERATION */
/* OR A BASE 2 ITERATION IF NEEDED. */

/* THE SUBROUTINE IS CALLED AS SUBROUTINE FFT842 (IN,N,X,Y). */
/* THE INTEGER N (A POWER OF 2), THE N REAL LOCATION ARRAY X, AND */
/* THE N REAL LOCATION ARRAY Y MUST BE SUPPLIED TO THE SUBROUTINE. */

/*<       DIMENSION X(*), Y(*), L(15) >*/
/*<       COMMON /CON2/ PI2, P7 >*/
/*<       EQUIVALENCE (L15,L(1)), (L14,L(2)), (L13,L(3)), (L12,L(4)), >*/
/*<      *    (L11,L(5)), (L10,L(6)), (L9,L(7)), (L8,L(8)), (L7,L(9)), >*/
/*<      *    (L6,L(10)), (L5,L(11)), (L4,L(12)), (L3,L(13)), (L2,L(14)), >*/
/*<      *    (L1,L(15)) >*/

/*<       PI2 = 8.*ATAN(1.) >*/
    con2_1.pi2 = katan(1.) * 8.;
/*<       P7 = 1./SQRT(2.) >*/
    con2_1.p7 = 1. / ksqrt(2.);
/*<       DO 10 I=1,15 >*/
    for (i = 1; i <= 15; ++i) {
/*<         M = I >*/
	m = i;
/*<         NT = 2**I >*/
	nt = pow_ii(&c__2, &i);
/*<         IF (N.EQ.NT) GO TO 20 >*/
	if (*n == nt) {
	    goto L20;
	}
/*<   10  CONTINUE >*/
/* L10: */
    }
/*<   20  N2POW = M >*/
L20:
    n2pow = m;
/*<       NTHPO = N >*/
    nthpo = *n;
/*<       FN = NTHPO >*/
    fn = (doublereal) nthpo;
/*<       IF (IN.EQ.1) GO TO 40 >*/
    if (*in == 1) {
	goto L40;
    }
/*<       DO 30 I=1,NTHPO >*/
    i_1 = nthpo;
    for (i = 1; i <= i_1; ++i) {
/*<         Y(I) = -Y(I) >*/
	y[i] = -y[i];
/*<   30  CONTINUE >*/
/* L30: */
    }
/*<   40  N8POW = N2POW/3 >*/
L40:
    n8pow = n2pow / 3;
/*<       IF (N8POW.EQ.0) GO TO 60 >*/
    if (n8pow == 0) {
	goto L60;
    }

/* RADIX 8 PASSES,IF ANY. */

/*<       DO 50 IPASS=1,N8POW >*/
    i_1 = n8pow;
    for (ipass = 1; ipass <= i_1; ++ipass) {
/*<         NXTLT = 2**(N2POW-3*IPASS) >*/
	i_2 = n2pow - ipass * 3;
	nxtlt = pow_ii(&c__2, &i_2);
/*<         LENGT = 8*NXTLT >*/
	lengt = nxtlt << 3;
/*<         CALL R8TX(NXTLT, NTHPO, LENGT, X(1), X(NXTLT+1), X(2*NXTLT+1), >*/
/*<      *      X(3*NXTLT+1), X(4*NXTLT+1), X(5*NXTLT+1), X(6*NXTLT+1), >*/
/*<      *      X(7*NXTLT+1), Y(1), Y(NXTLT+1), Y(2*NXTLT+1), Y(3*NXTLT+1), >*/
/*<      *      Y(4*NXTLT+1), Y(5*NXTLT+1), Y(6*NXTLT+1), Y(7*NXTLT+1)) >*/
	r8tx_(&nxtlt, &nthpo, &lengt, &x[1], &x[nxtlt + 1], &x[(nxtlt << 1) + 
		1], &x[nxtlt * 3 + 1], &x[(nxtlt << 2) + 1], &x[nxtlt * 5 + 1]
		, &x[nxtlt * 6 + 1], &x[nxtlt * 7 + 1], &y[1], &y[nxtlt + 1], 
		&y[(nxtlt << 1) + 1], &y[nxtlt * 3 + 1], &y[(nxtlt << 2) + 1],
		 &y[nxtlt * 5 + 1], &y[nxtlt * 6 + 1], &y[nxtlt * 7 + 1]);
/*<   50  CONTINUE >*/
/* L50: */
    }

/* IS THERE A FOUR FACTOR LEFT */

/*<   60  IF (N2POW-3*N8POW-1) 90, 70, 80 >*/
L60:
    if ((i_1 = n2pow - n8pow * 3 - 1) < 0) {
	goto L90;
    } else if (i_1 == 0) {
	goto L70;
    } else {
	goto L80;
    }

/* GO THROUGH THE BASE 2 ITERATION */


/*<   70  CALL R2TX(NTHPO, X(1), X(2), Y(1), Y(2)) >*/
L70:
    r2tx_(&nthpo, &x[1], &x[2], &y[1], &y[2]);
/*<       GO TO 90 >*/
    goto L90;

/* GO THROUGH THE BASE 4 ITERATION */

/*<   80  CALL R4TX(NTHPO, X(1), X(2), X(3), X(4), Y(1), Y(2), Y(3), Y(4)) >*/
L80:
    r4tx_(&nthpo, &x[1], &x[2], &x[3], &x[4], &y[1], &y[2], &y[3], &y[4]);

/*<   90  DO 110 J=1,15 >*/
L90:
    for (j = 1; j <= 15; ++j) {
/*<         L(J) = 1 >*/
	l[j - 1] = 1;
/*<         IF (J-N2POW) 100, 100, 110 >*/
	if (j - n2pow <= 0) {
	    goto L100;
	} else {
	    goto L110;
	}
/*<  100    L(J) = 2**(N2POW+1-J) >*/
L100:
	i_1 = n2pow + 1 - j;
	l[j - 1] = pow_ii(&c__2, &i_1);
/*<  110  CONTINUE >*/
L110:
    ;}
/*<       IJ = 1 >*/
    ij = 1;
/*<       DO 130 J1=1,L1 >*/
    i_1 = *l1;
    for (j01 = 1; j01 <= i_1; ++j01) {
/*<       DO 130 J2=J1,L2,L1 >*/
	i_2 = *l2;
	i_3 = *l1;
	for (j2 = j01; i_3 < 0 ? j2 >= i_2 : j2 <= i_2; j2 += i_3) {
/*<       DO 130 J3=J2,L3,L2 >*/
	    i_4 = *l3;
	    i_5 = *l2;
	    for (j3 = j2; i_5 < 0 ? j3 >= i_4 : j3 <= i_4; j3 += i_5) {
/*<       DO 130 J4=J3,L4,L3 >*/
		i_6 = *l4;
		i_7 = *l3;
		for (j4 = j3; i_7 < 0 ? j4 >= i_6 : j4 <= i_6; j4 += i_7) {
/*<       DO 130 J5=J4,L5,L4 >*/
		    i_8 = *l5;
		    i_9 = *l4;
		    for (j5 = j4; i_9 < 0 ? j5 >= i_8 : j5 <= i_8; j5 += i_9) 
			    {
/*<       DO 130 J6=J5,L6,L5 >*/
			i_10 = *l6;
			i_11 = *l5;
			for (j6 = j5; i_11 < 0 ? j6 >= i_10 : j6 <= i_10; j6 
				+= i_11) {
/*<       DO 130 J7=J6,L7,L6 >*/
			    i_12 = *l7;
			    i_13 = *l6;
			    for (j7 = j6; i_13 < 0 ? j7 >= i_12 : j7 <= i_12; 
				    j7 += i_13) {
/*<       DO 130 J8=J7,L8,L7 >*/
				i_14 = *l8;
				i_15 = *l7;
				for (j8 = j7; i_15 < 0 ? j8 >= i_14 : j8 <= 
					i_14; j8 += i_15) {
/*<       DO 130 J9=J8,L9,L8 >*/
				    i_16 = *l9;
				    i_17 = *l8;
				    for (j9 = j8; i_17 < 0 ? j9 >= i_16 : j9 
					    <= i_16; j9 += i_17) {
/*<       DO 130 J10=J9,L10,L9 >*/
					i_18 = *l10;
					i_19 = *l9;
					for (j10 = j9; i_19 < 0 ? j10 >= i_18 
						: j10 <= i_18; j10 += i_19) {
/*<       DO 130 J11=J10,L11,L10 >*/
					    i_20 = *l11;
					    i_21 = *l10;
					    for (j11 = j10; i_21 < 0 ? j11 >= 
						    i_20 : j11 <= i_20; j11 +=
						     i_21) {
/*<       DO 130 J12=J11,L12,L11 >*/
			  i_22 = *l12;
			  i_23 = *l11;
			  for (j12 = j11; i_23 < 0 ? j12 >= i_22 : j12 <= 
				  i_22; j12 += i_23) {
/*<       DO 130 J13=J12,L13,L12 >*/
			      i_24 = *l13;
			      i_25 = *l12;
			      for (j13 = j12; i_25 < 0 ? j13 >= i_24 : j13 <= 
				      i_24; j13 += i_25) {
/*<       DO 130 J14=J13,L14,L13 >*/
				  i_26 = *l14;
				  i_27 = *l13;
				  for (j14 = j13; i_27 < 0 ? j14 >= i_26 : 
					  j14 <= i_26; j14 += i_27) {
/*<       DO 130 JI=J14,L15,L14 >*/
				      i_28 = *l15;
				      i_29 = *l14;
				      for (ji = j14; i_29 < 0 ? ji >= i_28 : 
					      ji <= i_28; ji += i_29) {
/*<         IF (IJ-JI) 120, 130, 130 >*/
					  if (ij - ji >= 0) {
			goto L130;
					  } else {
			goto L120;
					  }
/*<  120    R = X(IJ) >*/
L120:
					  r = x[ij];
/*<         X(IJ) = X(JI) >*/
					  x[ij] = x[ji];
/*<         X(JI) = R >*/
					  x[ji] = r;
/*<         FI = Y(IJ) >*/
					  fi = y[ij];
/*<         Y(IJ) = Y(JI) >*/
					  y[ij] = y[ji];
/*<         Y(JI) = FI >*/
					  y[ji] = fi;
/*<  130    IJ = IJ + 1 >*/
L130:
					  ++ij;
				      }
				  }
			      }
			  }
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
/*<       IF (IN.EQ.1) GO TO 150 >*/
    if (*in == 1) {
	goto L150;
    }
/*<       DO 140 I=1,NTHPO >*/
    i_29 = nthpo;
    for (i = 1; i <= i_29; ++i) {
/*<         Y(I) = -Y(I) >*/
	y[i] = -y[i];
/*<  140  CONTINUE >*/
/* L140: */
    }
/*<       GO TO 170 >*/
    goto L170;
/*<  150  DO 160 I=1,NTHPO >*/
L150:
    i_29 = nthpo;
    for (i = 1; i <= i_29; ++i) {
/*<         X(I) = X(I)/FN >*/
	x[i] /= fn;
/*<         Y(I) = Y(I)/FN >*/
	y[i] /= fn;
/*<  160  CONTINUE >*/
/* L160: */
    }
/*<  170  RETURN >*/
L170:
    return 0;
/*<       END >*/
} /* fft842_ */

#undef l15
#undef l14
#undef l13
#undef l12
#undef l11
#undef l10
#undef l9
#undef l8
#undef l7
#undef l6
#undef l5
#undef l4
#undef l3
#undef l2
#undef l1
#undef l



/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  R2TX */
/* RADIX 2 ITERATION SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE R2TX(NTHPO, CR0, CR1, CI0, CI1) >*/
/* Subroutine */ int r2tx_(integer *nthpo, doublereal *cr0, doublereal *cr1, 
	doublereal *ci0, doublereal *ci1)
{
    /* System generated locals */
    integer i_1;

    /* Local variables */
    integer k;
    doublereal r1, fi1;

    /* Parameter adjustments */
    --cr0;
    --cr1;
    --ci0;
    --ci1;

    /* Function Body */
/*<       DIMENSION CR0(2), CR1(2), CI0(2), CI1(2) >*/
/*<       DO 10 K=1,NTHPO,2 >*/
    i_1 = *nthpo;
    for (k = 1; k <= i_1; k += 2) {
/*<         R1 = CR0(K) + CR1(K) >*/
	r1 = cr0[k] + cr1[k];
/*<         CR1(K) = CR0(K) - CR1(K) >*/
	cr1[k] = cr0[k] - cr1[k];
/*<         CR0(K) = R1 >*/
	cr0[k] = r1;
/*<         FI1 = CI0(K) + CI1(K) >*/
	fi1 = ci0[k] + ci1[k];
/*<         CI1(K) = CI0(K) - CI1(K) >*/
	ci1[k] = ci0[k] - ci1[k];
/*<         CI0(K) = FI1 >*/
	ci0[k] = fi1;
/*<   10  CONTINUE >*/
/* L10: */
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* r2tx_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  R4TX */
/* RADIX 4 ITERATION SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE R4TX(NTHPO, CR0, CR1, CR2, CR3, CI0, CI1, CI2, CI3) >*/
/* Subroutine */ int r4tx_(integer *nthpo, doublereal *cr0, doublereal *cr1, 
	doublereal *cr2, doublereal *cr3, doublereal *ci0, doublereal *ci1, 
	doublereal *ci2, doublereal *ci3)
{
    /* System generated locals */
    integer i_1;

    /* Local variables */
    integer k;
    doublereal r1, r2, r3, r4, fi1, fi2, fi3, fi4;

    /* Parameter adjustments */
    --cr0;
    --cr1;
    --cr2;
    --cr3;
    --ci0;
    --ci1;
    --ci2;
    --ci3;

    /* Function Body */
/*<       DIMENSION CR0(2), CR1(2), CR2(2), CR3(2), CI0(2), CI1(2), CI2(2), >*/
/*<      *    CI3(2) >*/
/*<       DO 10 K=1,NTHPO,4 >*/
    i_1 = *nthpo;
    for (k = 1; k <= i_1; k += 4) {
/*<         R1 = CR0(K) + CR2(K) >*/
	r1 = cr0[k] + cr2[k];
/*<         R2 = CR0(K) - CR2(K) >*/
	r2 = cr0[k] - cr2[k];
/*<         R3 = CR1(K) + CR3(K) >*/
	r3 = cr1[k] + cr3[k];
/*<         R4 = CR1(K) - CR3(K) >*/
	r4 = cr1[k] - cr3[k];
/*<         FI1 = CI0(K) + CI2(K) >*/
	fi1 = ci0[k] + ci2[k];
/*<         FI2 = CI0(K) - CI2(K) >*/
	fi2 = ci0[k] - ci2[k];
/*<         FI3 = CI1(K) + CI3(K) >*/
	fi3 = ci1[k] + ci3[k];
/*<         FI4 = CI1(K) - CI3(K) >*/
	fi4 = ci1[k] - ci3[k];
/*<         CR0(K) = R1 + R3 >*/
	cr0[k] = r1 + r3;
/*<         CI0(K) = FI1 + FI3 >*/
	ci0[k] = fi1 + fi3;
/*<         CR1(K) = R1 - R3 >*/
	cr1[k] = r1 - r3;
/*<         CI1(K) = FI1 - FI3 >*/
	ci1[k] = fi1 - fi3;
/*<         CR2(K) = R2 - FI4 >*/
	cr2[k] = r2 - fi4;
/*<         CI2(K) = FI2 + R4 >*/
	ci2[k] = fi2 + r4;
/*<         CR3(K) = R2 + FI4 >*/
	cr3[k] = r2 + fi4;
/*<         CI3(K) = FI2 - R4 >*/
	ci3[k] = fi2 - r4;
/*<   10  CONTINUE >*/
/* L10: */
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* r4tx_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  R8TX */
/* RADIX 8 ITERATION SUBROUTINE */
/* ----------------------------------------------------------------------- */

/*<       SUBROUTINE R8TX(NXTLT, NTHPO, LENGT, CR0, CR1, CR2, CR3, CR4, >*/
/*<      *    CR5, CR6, CR7, CI0, CI1, CI2, CI3, CI4, CI5, CI6, CI7) >*/
/* Subroutine */ int r8tx_(integer *nxtlt, integer *nthpo, integer *lengt, 
	doublereal *cr0, doublereal *cr1, doublereal *cr2, doublereal *cr3, 
	doublereal *cr4, doublereal *cr5, doublereal *cr6, doublereal *cr7, 
	doublereal *ci0, doublereal *ci1, doublereal *ci2, doublereal *ci3, 
	doublereal *ci4, doublereal *ci5, doublereal *ci6, doublereal *ci7)
{
    /* System generated locals */
    integer i_1, i_2, i_3;
    doublereal d_1, d_2;

    /* Local variables */
    integer j, k;
    doublereal scale, c1, c2, c3, c4, c5, c6, c7, s1, s2, s3, s4, s5, s6, s7, 
	    ti, tr, ai0, ai1, ar0, ar1, ar2, ar3, ar4, ar5, ar6, ar7, ai2, 
	    ai3, ai4, ai5, ai6, ai7, br0, br1, br2, br3, br4, br5, br6, br7, 
	    bi0, bi1, bi2, bi3, bi4, bi5, bi6, bi7, arg;

    /* Parameter adjustments */
    --cr0;
    --cr1;
    --cr2;
    --cr3;
    --cr4;
    --cr5;
    --cr6;
    --cr7;
    --ci0;
    --ci1;
    --ci2;
    --ci3;
    --ci4;
    --ci5;
    --ci6;
    --ci7;

    /* Function Body */
/*<       DIMENSION CR0(2), CR1(2), CR2(2), CR3(2), CR4(2), CR5(2), CR6(2), >*/
/*<      *    CR7(2), CI1(2), CI2(2), CI3(2), CI4(2), CI5(2), CI6(2), >*/
/*<      *    CI7(2), CI0(2) >*/
/*<       COMMON /CON2/ PI2, P7 >*/

/*<       SCALE = PI2/FLOAT(LENGT) >*/
    scale = con2_1.pi2 / (doublereal) (*lengt);
/*<       DO 30 J=1,NXTLT >*/
    i_1 = *nxtlt;
    for (j = 1; j <= i_1; ++j) {
/*<         ARG = FLOAT(J-1)*SCALE >*/
	arg = (doublereal) (j - 1) * scale;
/*<         C1 = COS(ARG) >*/
	c1 = kcos(arg);
/*<         S1 = SIN(ARG) >*/
	s1 = ksin(arg);
/*<         C2 = C1**2 - S1**2 >*/
/* Computing 2nd power */
	d_1 = c1;
/* Computing 2nd power */
	d_2 = s1;
	c2 = d_1 * d_1 - d_2 * d_2;
/*<         S2 = C1*S1 + C1*S1 >*/
	s2 = c1 * s1 + c1 * s1;
/*<         C3 = C1*C2 - S1*S2 >*/
	c3 = c1 * c2 - s1 * s2;
/*<         S3 = C2*S1 + S2*C1 >*/
	s3 = c2 * s1 + s2 * c1;
/*<         C4 = C2**2 - S2**2 >*/
/* Computing 2nd power */
	d_1 = c2;
/* Computing 2nd power */
	d_2 = s2;
	c4 = d_1 * d_1 - d_2 * d_2;
/*<         S4 = C2*S2 + C2*S2 >*/
	s4 = c2 * s2 + c2 * s2;
/*<         C5 = C2*C3 - S2*S3 >*/
	c5 = c2 * c3 - s2 * s3;
/*<         S5 = C3*S2 + S3*C2 >*/
	s5 = c3 * s2 + s3 * c2;
/*<         C6 = C3**2 - S3**2 >*/
/* Computing 2nd power */
	d_1 = c3;
/* Computing 2nd power */
	d_2 = s3;
	c6 = d_1 * d_1 - d_2 * d_2;
/*<         S6 = C3*S3 + C3*S3 >*/
	s6 = c3 * s3 + c3 * s3;
/*<         C7 = C3*C4 - S3*S4 >*/
	c7 = c3 * c4 - s3 * s4;
/*<         S7 = C4*S3 + S4*C3 >*/
	s7 = c4 * s3 + s4 * c3;
/*<         DO 20 K=J,NTHPO,LENGT >*/
	i_2 = *nthpo;
	i_3 = *lengt;
	for (k = j; i_3 < 0 ? k >= i_2 : k <= i_2; k += i_3) {
/*<           AR0 = CR0(K) + CR4(K) >*/
	    ar0 = cr0[k] + cr4[k];
/*<           AR1 = CR1(K) + CR5(K) >*/
	    ar1 = cr1[k] + cr5[k];
/*<           AR2 = CR2(K) + CR6(K) >*/
	    ar2 = cr2[k] + cr6[k];
/*<           AR3 = CR3(K) + CR7(K) >*/
	    ar3 = cr3[k] + cr7[k];
/*<           AR4 = CR0(K) - CR4(K) >*/
	    ar4 = cr0[k] - cr4[k];
/*<           AR5 = CR1(K) - CR5(K) >*/
	    ar5 = cr1[k] - cr5[k];
/*<           AR6 = CR2(K) - CR6(K) >*/
	    ar6 = cr2[k] - cr6[k];
/*<           AR7 = CR3(K) - CR7(K) >*/
	    ar7 = cr3[k] - cr7[k];
/*<           AI0 = CI0(K) + CI4(K) >*/
	    ai0 = ci0[k] + ci4[k];
/*<           AI1 = CI1(K) + CI5(K) >*/
	    ai1 = ci1[k] + ci5[k];
/*<           AI2 = CI2(K) + CI6(K) >*/
	    ai2 = ci2[k] + ci6[k];
/*<           AI3 = CI3(K) + CI7(K) >*/
	    ai3 = ci3[k] + ci7[k];
/*<           AI4 = CI0(K) - CI4(K) >*/
	    ai4 = ci0[k] - ci4[k];
/*<           AI5 = CI1(K) - CI5(K) >*/
	    ai5 = ci1[k] - ci5[k];
/*<           AI6 = CI2(K) - CI6(K) >*/
	    ai6 = ci2[k] - ci6[k];
/*<           AI7 = CI3(K) - CI7(K) >*/
	    ai7 = ci3[k] - ci7[k];
/*<           BR0 = AR0 + AR2 >*/
	    br0 = ar0 + ar2;
/*<           BR1 = AR1 + AR3 >*/
	    br1 = ar1 + ar3;
/*<           BR2 = AR0 - AR2 >*/
	    br2 = ar0 - ar2;
/*<           BR3 = AR1 - AR3 >*/
	    br3 = ar1 - ar3;
/*<           BR4 = AR4 - AI6 >*/
	    br4 = ar4 - ai6;
/*<           BR5 = AR5 - AI7 >*/
	    br5 = ar5 - ai7;
/*<           BR6 = AR4 + AI6 >*/
	    br6 = ar4 + ai6;
/*<           BR7 = AR5 + AI7 >*/
	    br7 = ar5 + ai7;
/*<           BI0 = AI0 + AI2 >*/
	    bi0 = ai0 + ai2;
/*<           BI1 = AI1 + AI3 >*/
	    bi1 = ai1 + ai3;
/*<           BI2 = AI0 - AI2 >*/
	    bi2 = ai0 - ai2;
/*<           BI3 = AI1 - AI3 >*/
	    bi3 = ai1 - ai3;
/*<           BI4 = AI4 + AR6 >*/
	    bi4 = ai4 + ar6;
/*<           BI5 = AI5 + AR7 >*/
	    bi5 = ai5 + ar7;
/*<           BI6 = AI4 - AR6 >*/
	    bi6 = ai4 - ar6;
/*<           BI7 = AI5 - AR7 >*/
	    bi7 = ai5 - ar7;
/*<           CR0(K) = BR0 + BR1 >*/
	    cr0[k] = br0 + br1;
/*<           CI0(K) = BI0 + BI1 >*/
	    ci0[k] = bi0 + bi1;
/*<           IF (J.LE.1) GO TO 10 >*/
	    if (j <= 1) {
		goto L10;
	    }
/*<           CR1(K) = C4*(BR0-BR1) - S4*(BI0-BI1) >*/
	    cr1[k] = c4 * (br0 - br1) - s4 * (bi0 - bi1);
/*<           CI1(K) = C4*(BI0-BI1) + S4*(BR0-BR1) >*/
	    ci1[k] = c4 * (bi0 - bi1) + s4 * (br0 - br1);
/*<           CR2(K) = C2*(BR2-BI3) - S2*(BI2+BR3) >*/
	    cr2[k] = c2 * (br2 - bi3) - s2 * (bi2 + br3);
/*<           CI2(K) = C2*(BI2+BR3) + S2*(BR2-BI3) >*/
	    ci2[k] = c2 * (bi2 + br3) + s2 * (br2 - bi3);
/*<           CR3(K) = C6*(BR2+BI3) - S6*(BI2-BR3) >*/
	    cr3[k] = c6 * (br2 + bi3) - s6 * (bi2 - br3);
/*<           CI3(K) = C6*(BI2-BR3) + S6*(BR2+BI3) >*/
	    ci3[k] = c6 * (bi2 - br3) + s6 * (br2 + bi3);
/*<           TR = P7*(BR5-BI5) >*/
	    tr = con2_1.p7 * (br5 - bi5);
/*<           TI = P7*(BR5+BI5) >*/
	    ti = con2_1.p7 * (br5 + bi5);
/*<           CR4(K) = C1*(BR4+TR) - S1*(BI4+TI) >*/
	    cr4[k] = c1 * (br4 + tr) - s1 * (bi4 + ti);
/*<           CI4(K) = C1*(BI4+TI) + S1*(BR4+TR) >*/
	    ci4[k] = c1 * (bi4 + ti) + s1 * (br4 + tr);
/*<           CR5(K) = C5*(BR4-TR) - S5*(BI4-TI) >*/
	    cr5[k] = c5 * (br4 - tr) - s5 * (bi4 - ti);
/*<           CI5(K) = C5*(BI4-TI) + S5*(BR4-TR) >*/
	    ci5[k] = c5 * (bi4 - ti) + s5 * (br4 - tr);
/*<           TR = -P7*(BR7+BI7) >*/
	    tr = -con2_1.p7 * (br7 + bi7);
/*<           TI = P7*(BR7-BI7) >*/
	    ti = con2_1.p7 * (br7 - bi7);
/*<           CR6(K) = C3*(BR6+TR) - S3*(BI6+TI) >*/
	    cr6[k] = c3 * (br6 + tr) - s3 * (bi6 + ti);
/*<           CI6(K) = C3*(BI6+TI) + S3*(BR6+TR) >*/
	    ci6[k] = c3 * (bi6 + ti) + s3 * (br6 + tr);
/*<           CR7(K) = C7*(BR6-TR) - S7*(BI6-TI) >*/
	    cr7[k] = c7 * (br6 - tr) - s7 * (bi6 - ti);
/*<           CI7(K) = C7*(BI6-TI) + S7*(BR6-TR) >*/
	    ci7[k] = c7 * (bi6 - ti) + s7 * (br6 - tr);
/*<           GO TO 20 >*/
	    goto L20;
/*<   10      CR1(K) = BR0 - BR1 >*/
L10:
	    cr1[k] = br0 - br1;
/*<           CI1(K) = BI0 - BI1 >*/
	    ci1[k] = bi0 - bi1;
/*<           CR2(K) = BR2 - BI3 >*/
	    cr2[k] = br2 - bi3;
/*<           CI2(K) = BI2 + BR3 >*/
	    ci2[k] = bi2 + br3;
/*<           CR3(K) = BR2 + BI3 >*/
	    cr3[k] = br2 + bi3;
/*<           CI3(K) = BI2 - BR3 >*/
	    ci3[k] = bi2 - br3;
/*<           TR = P7*(BR5-BI5) >*/
	    tr = con2_1.p7 * (br5 - bi5);
/*<           TI = P7*(BR5+BI5) >*/
	    ti = con2_1.p7 * (br5 + bi5);
/*<           CR4(K) = BR4 + TR >*/
	    cr4[k] = br4 + tr;
/*<           CI4(K) = BI4 + TI >*/
	    ci4[k] = bi4 + ti;
/*<           CR5(K) = BR4 - TR >*/
	    cr5[k] = br4 - tr;
/*<           CI5(K) = BI4 - TI >*/
	    ci5[k] = bi4 - ti;
/*<           TR = -P7*(BR7+BI7) >*/
	    tr = -con2_1.p7 * (br7 + bi7);
/*<           TI = P7*(BR7-BI7) >*/
	    ti = con2_1.p7 * (br7 - bi7);
/*<           CR6(K) = BR6 + TR >*/
	    cr6[k] = br6 + tr;
/*<           CI6(K) = BI6 + TI >*/
	    ci6[k] = bi6 + ti;
/*<           CR7(K) = BR6 - TR >*/
	    cr7[k] = br6 - tr;
/*<           CI7(K) = BI6 - TI >*/
	    ci7[k] = bi6 - ti;
/*<   20    CONTINUE >*/
L20:
	;}
/*<   30  CONTINUE >*/
/* L30: */
    }
/*<       RETURN >*/
    return 0;
/*<       END >*/
} /* r8tx_ */


static integer pow_ii(integer *ap, integer *bp)
{
integer pow_tmp, x, n;

pow_tmp = 1;
x = *ap;
n = *bp;

if(n < 0)
	{ }
else if(n > 0)
	for( ; ; )
		{
		if(n & 01)
			pow_tmp *= x;
		if(n >>= 1)
			x *= x;
		else
			break;
		}
return(pow_tmp);
}
