/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                Form Tree Searching Routines           <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                kvf_search_sel_guide()                 <<<<
   >>>>                kvf_variable_sel_search()              <<<<
   >>>>                kvf_search_sel_subform_action()        <<<<
   >>>>                kvf_search_sel_master_action()         <<<<
   >>>>   Static:                                             <<<<
   >>>>                kvf_search_selections_for_variable     <<<<
   >>>>                                                       <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/* search.c */
static kselection 
	*kvf_search_selections_for_variable PROTO((kselection *, int));

/*-----------------------------------------------------------
|
|  Routine Name: kvf_search_sel_guide(subform)
|
|       Purpose: Searches a form for a guide button that is selected.  
|                Written specifically for use by cantata.
|
|         Input: subform     - pointer to a subform tree.
|        Output: Returns a pointer to the selected guide button if
|                one is selected, or NULL if none are selected.
|
|    Written By: Danielle Argiro
|          Date: Jul 08, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

kguide *kvf_search_sel_guide(
   ksubform *subform)
{
	kguide *guide;

	if (subform->guidepane != NULL)
	    guide = subform->guidepane->guide_list;
	else guide = subform->guide;

	while (guide != NULL)
	{
	    if (guide->selected) return(guide);
	    guide = guide->next;
	}
	return(NULL);
}
   

/*-----------------------------------------------------------
|
|  Routine Name: kvf_variable_sel_search
|
|       Purpose: Searches for a particular selection in the
|		 form tree based on the provided variable as the key.
|
|         Input: form - pointer to the subform tree
|		 variable - desired variable 
|
|        Output: pointer to the correct selection, or
|		 NULL if a selection with the desired variable could
|		 not be found
|
|    Written By: Danielle Argiro
|          Date: Jul 08, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
--------------------------------------------------------------------*/


kselection *kvf_variable_sel_search(
   kform *form,
   char  *variable)
{
	ksubform  *subform;
	kguide     *guide;
	kselection *selection;
	int           var_token;

	if (form == NULL)
	    return(NULL);

	var_token = kstring_to_token(variable);

	if (form->master != NULL)
	{
	    subform = form->master->subform_list;
	    if ((selection = kvf_search_selections_for_variable(
			form->master->sel_list, var_token)) != NULL)
		return(selection);
	}
	else subform = form->subform;

	while (subform != NULL)
	{
	    if (subform->guidepane != NULL)
	    {
		guide = subform->guidepane->guide_list;
	        if ((selection = kvf_search_selections_for_variable(
			subform->guidepane->sel_list, var_token)) != NULL)
		return(selection);
	    }
	    else guide = subform->guide;
	    while (guide != NULL) 
	    {
	        if (guide->pane != NULL)
		    if ((selection = kvf_search_selections_for_variable(
				guide->pane->sel_list, var_token)) != NULL)
			return(selection);
	        guide = guide->next;
	    }
	    subform = subform->next;
	}
	return(NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: kvf_search_selections_for_variable()
|
|       Purpose: Searches a list of selections for a particular variable.
|
|         Input: sel_list  - pointer to selection list.
|                var_token - tokenized representation of desired variable
|
|        Output: Returns a pointer to the selection with the variable
|                on success, NULL on failure.
|
|    Written By: Danielle Argiro
|          Date: Jul 08, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/
static kselection *kvf_search_selections_for_variable(
   kselection *sel_list,
   int        var_token)
{
	kselection *group;
	kselection *selection;

	selection = sel_list;
	while (selection != NULL) 
	{
	    if (var_token  == selection->var_token)
		return(selection);
	    if (selection->group_next != NULL)
	    {
		group = 
		   kvf_search_selections_for_variable(selection->group_next,
					              var_token);
		if (group != NULL)
		    return(group);
	    }
	    selection = selection->next;
	}
	return(NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: kvf_search_sel_subform_action()
|
|       Purpose: Searches a guidepane for a KUIS_SUBFORMACTION button that 
|                is selected.  Written specifically for use by cantata.
|
|         Input: subform - pointer to a form tree.
|        Output: Returns a pointer to the selection representing
|  		 selected subform action button on success, 
|                NULL on failure.
|    Written By: Danielle Argiro
|          Date: May 7, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

kselection *kvf_search_sel_subform_action(
   ksubform *subform)
{
	kselection *selection;

	if (subform->guidepane != NULL)
	    selection = subform->guidepane->sel_list;
	else return(NULL);

	while (selection != NULL)
	{
	    if ((selection->type == KUIS_SUBFORMACTION) &&
		(selection->selected == TRUE))
	        return(selection);
            selection = selection->next;
   	}

	return(NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: kvf_search_sel_master_action()
|
|       Purpose: Searches a master for a KUIS_MASTERACTION button that 
|                is selected.  Written specifically for use by cantata.
|
|         Input: form - pointer to a form tree.
|        Output: Returns a pointer to the selection representing
|  		 selected master action button on success, 
|                NULL on failure.
|
|    Written By: Danielle Argiro
|          Date: May 7, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/
kselection *kvf_search_sel_master_action(
   kform *form)
{
        kselection *selection;

        if (form->master != NULL)
            selection = form->master->sel_list;
        else return(NULL);

        while (selection != NULL)
        {
            if ((selection->type == KUIS_MASTERACTION) &&
                (selection->selected == TRUE))
                return(selection);
            selection = selection->next;
        }
        return(NULL);
}

